/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield.compatibility;

import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.objects.annotations.Getter;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import tk.playerforcehd.shield.Main;
import tk.playerforcehd.shield.compatibility.CompatibilityModule;
import tk.playerforcehd.shield.compatibility.modules.citizens.CitizensCompatibilityModule;

public class CompatibilityManager {
    private List<CompatibilityModule> loadedModules = new ArrayList<CompatibilityModule>();

    public void autoDetectCompatibilityPlugins() {
        if (Main.getInstance().getDataReader().isAutoDetectCompatibles() && Main.getInstance().getDataReader().isEnableCompatibilityMode()) {
            Plugin[] plugins;
            this.reset();
            Main.getInstance().getLogger().info("Compatibility Mode is enabled, loading modules!");
            block3: for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
                for (CompatiblePlugins compatiblePlugins : CompatiblePlugins.values()) {
                    if (!plugin.getDescription().getName().equalsIgnoreCase(compatiblePlugins.toString())) continue;
                    CompatibilityModule compatibilityModule = null;
                    try {
                        compatibilityModule = this.loadPlugin(compatiblePlugins);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    this.loadedModules.add(compatibilityModule);
                    continue block3;
                }
            }
            Main.getInstance().getLogger().info("Loaded Compatibility Modules!");
        }
    }

    public void enableAll() {
        for (CompatibilityModule loadedModule : this.loadedModules) {
            loadedModule.enable();
        }
    }

    public void disableAll() {
        for (CompatibilityModule loadedModule : this.loadedModules) {
            loadedModule.disable();
        }
    }

    public void loadModulesFromList() {
        if (!Main.getInstance().getDataReader().isAutoDetectCompatibles() && Main.getInstance().getDataReader().isEnableCompatibilityMode()) {
            this.reset();
            Main.getInstance().getLogger().info("Compatibility Mode is enabled, loading modules!");
            for (String s : Main.getInstance().getDataReader().getMakeCompatiblePlugins()) {
                for (CompatiblePlugins compatiblePlugins : CompatiblePlugins.values()) {
                    Plugin plugin;
                    if (!s.equalsIgnoreCase(compatiblePlugins.toString()) || (plugin = Bukkit.getPluginManager().getPlugin(compatiblePlugins.toString())) == null) continue;
                    CompatibilityModule compatibilityModule = null;
                    try {
                        compatibilityModule = this.loadPlugin(compatiblePlugins);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    this.loadedModules.add(compatibilityModule);
                }
            }
            Main.getInstance().getLogger().info("Loaded Compatibility Modules!");
        }
    }

    public void reset() {
        for (CompatibilityModule loadedModule : this.loadedModules) {
            loadedModule.disable();
        }
        this.loadedModules.clear();
    }

    public CompatibilityModule loadPlugin(CompatiblePlugins compatiblePlugins) throws IllegalAccessException, InstantiationException {
        Class<? extends CompatibilityModule> clazz = compatiblePlugins.getModuleClass();
        CompatibilityModule o = clazz.newInstance();
        Main.getInstance().getLogger().info("Loaded Compatibility Mode for plugin: " + compatiblePlugins.toString());
        return o;
    }

    @Getter
    public List<CompatibilityModule> getLoadedModules() {
        return this.loadedModules;
    }

    public static enum CompatiblePlugins {
        Citizens(CitizensCompatibilityModule.class);

        private Class<? extends CompatibilityModule> aClass;

        private CompatiblePlugins(Class<CitizensCompatibilityModule> aClass) {
            this.aClass = aClass;
        }

        @Getter
        public Class<? extends CompatibilityModule> getModuleClass() {
            return this.aClass;
        }
    }
}

