/*
 * Decompiled with CFR 0.152.
 */
package tk.playerforcehd.shield;

import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.objects.annotations.Getter;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import tk.playerforcehd.shield.DataReader;
import tk.playerforcehd.shield.command.cmd_shield;
import tk.playerforcehd.shield.compatibility.CompatibilityManager;
import tk.playerforcehd.shield.database.EnabledUsersTable;
import tk.playerforcehd.shield.effect.EffectManager;
import tk.playerforcehd.shield.listener.DeathFactory;
import tk.playerforcehd.shield.listener.InteractFactory;
import tk.playerforcehd.shield.listener.InventoryFactory;
import tk.playerforcehd.shield.listener.JoinFactory;
import tk.playerforcehd.shield.listener.MoveFactory;
import tk.playerforcehd.shield.listener.QuitFactory;
import tk.playerforcehd.shield.utils.WorldGuardWrapper;
import tk.playerforcehd.shield.utils.mysql.MySQL;
import tk.playerforcehd.shield.utils.update.UpdateChecker;

public class Main
extends JavaPlugin {
    private static Main instance;
    private static List<Player> shieldUsers;
    private boolean isUptodate = true;
    private DataReader dataReader;
    private UpdateChecker updateChecker;
    private boolean isWorldGuardHoooked = false;
    private WorldGuardWrapper worldGuardWrapper;
    private CompatibilityManager compatibilityManager;
    private MoveFactory moveFactory;
    private EffectManager effectManager;
    private MySQL mySQL;
    private EnabledUsersTable enabledUsersTable;
    private boolean useCrossServerEnabling = false;

    @Getter
    public static Main getInstance() {
        return instance;
    }

    @Getter
    public static List<Player> getShieldUsers() {
        return shieldUsers;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.dataReader = new DataReader();
        if (this.dataReader.isEnableMySQLConnection()) {
            this.mySQL = new MySQL((Plugin)this, this.dataReader.getHostMySQL(), this.dataReader.getPortMySQL(), this.dataReader.getDatabaseMySQL(), this.dataReader.getUsernameMySQL(), this.dataReader.getPasswordMySQL());
            this.mySQL.connect();
        }
        if (this.dataReader.isCross_server_enabled()) {
            if (this.dataReader.isEnableMySQLConnection()) {
                if (this.mySQL.isConnected()) {
                    this.enabledUsersTable = new EnabledUsersTable(this.mySQL);
                    this.useCrossServerEnabling = true;
                } else {
                    this.getLogger().warning("MySQL must be connected to a database to use CrossServerEnabling!");
                }
            } else {
                this.getLogger().warning("MySQL must be enabled to use CrossServerEnabling!");
            }
        }
        this.compatibilityManager = new CompatibilityManager();
        this.compatibilityManager.autoDetectCompatibilityPlugins();
        this.compatibilityManager.loadModulesFromList();
        this.compatibilityManager.enableAll();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new JoinFactory(), (Plugin)this);
        pm.registerEvents((Listener)new QuitFactory(), (Plugin)this);
        pm.registerEvents((Listener)new InteractFactory(), (Plugin)this);
        this.moveFactory = new MoveFactory();
        pm.registerEvents((Listener)this.moveFactory, (Plugin)this);
        pm.registerEvents((Listener)new InventoryFactory(), (Plugin)this);
        pm.registerEvents((Listener)new DeathFactory(), (Plugin)this);
        this.getCommand("shield").setExecutor((CommandExecutor)new cmd_shield());
        this.effectManager = new EffectManager();
        this.effectManager.startThread();
        this.prepareWorldGuardHook();
        this.getLogger().info("---------------- YouTuber Shield ----------------");
        this.getLogger().info("YouTuber Shield has been enabled!");
        this.getLogger().info("(C) PlayerForceHD");
        this.getLogger().info("---------------- YouTuber Shield ----------------");
        if (this.dataReader.isCheckForUpdates()) {
            this.getLogger().info("Checking for updates...");
            this.updateChecker = new UpdateChecker(this.getDescription().getVersion());
            this.isUptodate = this.updateChecker.isAvaible();
            if (this.isUptodate) {
                this.getLogger().info("---------------- YouTuber Shield Update ----------------");
                this.getLogger().info("A update is avaible!");
                this.getLogger().info("Old version -> " + this.updateChecker.getLocalVersion() + " | Available version: " + this.updateChecker.getVersion().getVersion());
                this.getLogger().info("Download at: " + this.updateChecker.getVersion().getUpdateURL());
                this.getLogger().info("---------------- YouTuber Shield Update ----------------");
            } else {
                this.getLogger().info("No new version available!");
            }
        }
    }

    private void prepareWorldGuardHook() {
        if (this.dataReader.isEnableWorldGuard()) {
            this.getLogger().info("WorldGuard support is enabled, hooking!");
            if (this.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
                this.worldGuardWrapper = new WorldGuardWrapper();
                this.isWorldGuardHoooked = this.worldGuardWrapper.hook();
                if (!this.isWorldGuardHoooked) {
                    this.getLogger().info("Failed to hook into WorldGuard!");
                } else {
                    this.getLogger().info("Successfully hooked into WorldGuard");
                }
            } else {
                this.getLogger().info("Can't hook into WorldGuard! WorldGuard is not installed!");
            }
        }
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        if (this.mySQL != null && this.mySQL.isConnected()) {
            this.mySQL.disconnect();
        }
        this.dataReader = new DataReader();
        if (this.dataReader.isEnableMySQLConnection()) {
            this.mySQL = new MySQL((Plugin)this, this.dataReader.getHostMySQL(), this.dataReader.getPortMySQL(), this.dataReader.getDatabaseMySQL(), this.dataReader.getUsernameMySQL(), this.dataReader.getPasswordMySQL());
            this.mySQL.connect();
        }
        if (this.dataReader.isCross_server_enabled()) {
            if (this.dataReader.isEnableMySQLConnection()) {
                if (this.mySQL.isConnected()) {
                    this.enabledUsersTable = new EnabledUsersTable(this.mySQL);
                    this.useCrossServerEnabling = true;
                } else {
                    this.getLogger().warning("MySQL must be connected to a database to use CrossServerEnabling!");
                    this.useCrossServerEnabling = false;
                }
            } else {
                this.getLogger().warning("MySQL must be enabled to use CrossServerEnabling!");
                this.useCrossServerEnabling = false;
            }
        } else {
            this.useCrossServerEnabling = false;
        }
        this.prepareWorldGuardHook();
        this.compatibilityManager.disableAll();
        this.compatibilityManager.reset();
        this.compatibilityManager.autoDetectCompatibilityPlugins();
        this.compatibilityManager.loadModulesFromList();
        this.compatibilityManager.enableAll();
        this.moveFactory.makeUpdate();
        this.effectManager.restartThread();
    }

    public void onDisable() {
        if (this.mySQL != null && this.mySQL.isConnected()) {
            this.mySQL.disconnect();
        }
        this.getLogger().info("---------------- YouTuber Shield ----------------");
        this.getLogger().info("YouTuber Shield has been disabled!");
        this.getLogger().info("(C) PlayerForceHD");
        this.getLogger().info("---------------- YouTuber Shield ----------------");
    }

    public ItemStack getShieldItem(Player player) {
        boolean isEnabled = false;
        if (Main.getShieldUsers().contains(player)) {
            isEnabled = true;
        }
        ItemStack i = new ItemStack(this.getDataReader().getItemType(), 1);
        ItemMeta im = i.getItemMeta();
        if (isEnabled) {
            im.setDisplayName(Main.getInstance().getDataReader().getItemName().replace("%status%", Main.getInstance().getDataReader().getActivated().replace("&", "\u00a7")).replace('&', '\u00a7'));
        } else {
            im.setDisplayName(Main.getInstance().getDataReader().getItemName().replace("%status%", Main.getInstance().getDataReader().getDeactivated().replace('&', '\u00a7')).replace('&', '\u00a7'));
        }
        ArrayList<String> tmp_lore = new ArrayList<String>();
        for (String loreEntry : Main.getInstance().getDataReader().getItemLore()) {
            String mSta = "";
            mSta = isEnabled ? loreEntry.replace("%status%", Main.getInstance().getDataReader().getActivated().replace('&', '\u00a7')).replace("&", "\u00a7") : loreEntry.replace("%status%", Main.getInstance().getDataReader().getDeactivated().replace('&', '\u00a7')).replace("&", "\u00a7");
            String fSta = mSta.replace('&', '\u00a7');
            tmp_lore.add(fSta);
        }
        im.setLore(tmp_lore);
        i.setItemMeta(im);
        return i;
    }

    public boolean isPermittedByMultiWorld(Player player) {
        if (this.getDataReader().isEnableMultiWorld()) {
            return !this.getDataReader().getDisabledWorlds().contains(player.getWorld().getName());
        }
        return true;
    }

    public boolean isPermittedByMultiWorld(Entity player) {
        if (this.getDataReader().isEnableMultiWorld()) {
            return !this.getDataReader().getDisabledWorlds().contains(player.getWorld().getName());
        }
        return true;
    }

    public boolean isPermittedByMultiWorldWhenNotShowMessage(Player player) {
        if (this.getDataReader().isEnableMultiWorld()) {
            if (this.getDataReader().getDisabledWorlds().contains(player.getWorld().getName())) {
                player.sendMessage(this.getDataReader().getPrefix().replace('&', '\u00a7') + this.getDataReader().getWorldDisabledMsg().replace('&', '\u00a7').replace("%world%", player.getWorld().getName()));
                return false;
            }
            return true;
        }
        return true;
    }

    public void sendRegionDisabledMessage(Player player) {
        player.sendMessage(this.dataReader.getPrefix().replace('&', '\u00a7') + this.dataReader.getRegionDisbaledMessage().replace('&', '\u00a7'));
    }

    @Getter
    public DataReader getDataReader() {
        return this.dataReader;
    }

    @Getter
    public boolean isUptodate() {
        return this.isUptodate;
    }

    @Getter
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Getter
    public WorldGuardWrapper getWorldGuardWrapper() {
        return this.worldGuardWrapper;
    }

    @Getter
    public boolean isWorldGuardHoooked() {
        return this.isWorldGuardHoooked;
    }

    @Getter
    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    public MySQL getMySQL() {
        return this.mySQL;
    }

    public boolean isUseCrossServerEnabling() {
        return this.useCrossServerEnabling;
    }

    public EnabledUsersTable getEnabledUsersTable() {
        return this.enabledUsersTable;
    }

    static {
        shieldUsers = new ArrayList<Player>();
    }
}

