/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.util;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.auscraft.BlivTrails.shade.ParticleEffect.ReflectionUtils;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GUIUtil {
    private static final int STACK_SIZE = 64;
    public static final ItemStack DEFAULT_ITEMSTACK = GUIUtil.addEnchantmentEffect(new ItemStack(Material.POTATO_ITEM, 1, 15));
    private static Class<?> NMS_ItemStack = null;
    private static Class<?> NMS_NBTTagCompound = null;
    private static Class<?> NMS_NBTTagList = null;
    private static Class<?> CRAFT_ItemStack = null;
    private static Method NMS_ItemStack_hasTag = null;
    private static Method NMS_ItemStack_setTag = null;
    private static Method NMS_ItemStack_getTag = null;
    private static Method NMS_NBTTagCompound_set = null;
    private static Method NMS_NBTTagCompound_remove = null;
    private static Method CRAFT_ItemStack_asNMSCopy = null;
    private static Method CRAFT_ItemStack_asCraftMirror = null;
    private static final Pattern COLON_SPLIT = Pattern.compile("[:]");

    public static ItemStack loadItem(ConfigurationSection configurationSection) {
        ItemContainer itemContainer = ItemContainer.buildItemContainer(configurationSection, true);
        if (itemContainer == null) {
            return DEFAULT_ITEMSTACK;
        }
        return GUIUtil.createItem(itemContainer);
    }

    private static String getErrorMessage(ConfigurationSection configurationSection, String path, String inputValue) {
        return "Error reading " + path + " at (" + configurationSection.getCurrentPath() + ")\n" + "Make sure this is a valid entry: " + (inputValue != null ? String.valueOf(inputValue) : "<BLANK>");
    }

    public static ItemStack createItem(ItemContainer itemContainer) {
        ItemStack item = GUIUtil.createItem(itemContainer.getMaterial(), itemContainer.getDamage(), itemContainer.getAmount(), itemContainer.getDisplayName(), itemContainer.getEnchantmentMap(), itemContainer.getLore());
        return itemContainer.getIsEnchanted() == 1 ? GUIUtil.addEnchantmentEffect(item) : item;
    }

    public static ItemStack createItem(Material material, int damage, int amount, String displayName, Map<Enchantment, Integer> enchants, List<String> lore) {
        ItemStack item = new ItemStack(material, amount, (short)damage);
        ItemMeta meta = item.getItemMeta();
        if (displayName != null && !displayName.isEmpty()) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
        }
        if (lore != null && !lore.isEmpty()) {
            meta.setLore(BUtil.translateColours(lore));
        }
        item.setItemMeta(meta);
        if (enchants != null && !enchants.isEmpty()) {
            if (material == Material.ENCHANTED_BOOK) {
                EnchantmentStorageMeta encMeta = (EnchantmentStorageMeta)item.getItemMeta();
                for (Map.Entry<Enchantment, Integer> enchantment : enchants.entrySet()) {
                    encMeta.addStoredEnchant(enchantment.getKey(), enchantment.getValue().intValue(), true);
                }
                item.setItemMeta((ItemMeta)encMeta);
            } else {
                item.addUnsafeEnchantments(enchants);
            }
        }
        return item;
    }

    private static boolean initEnchantmentNMS() {
        try {
            if (NMS_ItemStack == null) {
                NMS_ItemStack = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("ItemStack");
                NMS_NBTTagCompound = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("NBTTagCompound");
                NMS_NBTTagList = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("NBTTagList");
                CRAFT_ItemStack = ReflectionUtils.PackageType.CRAFTBUKKIT_INVENTORY.getClass("CraftItemStack");
                Class<?> NMS_NBTBase = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("NBTBase");
                NMS_ItemStack_hasTag = NMS_ItemStack.getMethod("hasTag", new Class[0]);
                NMS_ItemStack_setTag = NMS_ItemStack.getMethod("setTag", NMS_NBTTagCompound);
                NMS_ItemStack_getTag = NMS_ItemStack.getMethod("getTag", new Class[0]);
                NMS_NBTTagCompound_set = NMS_NBTTagCompound.getMethod("set", String.class, NMS_NBTBase);
                NMS_NBTTagCompound_remove = NMS_NBTTagCompound.getMethod("remove", String.class);
                CRAFT_ItemStack_asNMSCopy = CRAFT_ItemStack.getMethod("asNMSCopy", ItemStack.class);
                CRAFT_ItemStack_asCraftMirror = CRAFT_ItemStack.getMethod("asCraftMirror", NMS_ItemStack);
            }
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
            BUtil.logError("Your minecraft version seems to be modded. Enchantment effects will not be supported in this version.");
            return false;
        }
    }

    public static ItemStack addEnchantmentEffect(ItemStack item) {
        if (!GUIUtil.initEnchantmentNMS()) {
            return item;
        }
        try {
            Object nmsStack = CRAFT_ItemStack_asNMSCopy.invoke(null, item);
            Object tag = null;
            if (!((Boolean)NMS_ItemStack_hasTag.invoke(nmsStack, new Object[0])).booleanValue()) {
                tag = NMS_NBTTagCompound.newInstance();
                NMS_ItemStack_setTag.invoke(nmsStack, tag);
            }
            if (tag == null) {
                tag = NMS_ItemStack_getTag.invoke(nmsStack, new Object[0]);
            }
            Object enchTag = NMS_NBTTagList.newInstance();
            NMS_NBTTagCompound_set.invoke(tag, "ench", enchTag);
            NMS_ItemStack_setTag.invoke(nmsStack, tag);
            return (ItemStack)CRAFT_ItemStack_asCraftMirror.invoke(null, nmsStack);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            BUtil.logError("Your minecraft version seems to be modded. Enchantment effects will not be supported in this version.");
            return item;
        }
    }

    public static ItemStack removeEnchantmentEffect(ItemStack item) {
        if (!GUIUtil.initEnchantmentNMS()) {
            return item;
        }
        try {
            Object nmsStack = CRAFT_ItemStack_asNMSCopy.invoke((Object)item, new Object[0]);
            Object tag = null;
            if (!((Boolean)NMS_ItemStack_hasTag.invoke(nmsStack, new Object[0])).booleanValue()) {
                tag = NMS_NBTTagCompound.newInstance();
                NMS_ItemStack_setTag.invoke(nmsStack, tag);
            }
            if (tag == null) {
                tag = NMS_ItemStack_getTag.invoke(nmsStack, new Object[0]);
            }
            NMS_NBTTagCompound_remove.invoke(tag, "ench");
            NMS_ItemStack_setTag.invoke(nmsStack, tag);
            return (ItemStack)CRAFT_ItemStack_asCraftMirror.invoke(nmsStack, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            BUtil.logError("Your minecraft version seems to be modded. Enchantment effects will not be supported in this version.");
            return item;
        }
    }

    public static Map<Enchantment, Integer> addEnchantments(List<String> enchantList) {
        if (enchantList == null || enchantList.isEmpty()) {
            return null;
        }
        HashMap<Enchantment, Integer> enchantMap = new HashMap<Enchantment, Integer>();
        for (String enchantLine : enchantList) {
            String[] split = COLON_SPLIT.split(enchantLine);
            enchantMap.put(Enchantment.getByName((String)split[0]), Integer.parseInt(split[1]));
        }
        return enchantMap;
    }

    public static int countEmpty(Inventory inv) {
        int count = 0;
        for (ItemStack item : inv) {
            if (item != null) continue;
            ++count;
        }
        return count;
    }

    public static int countMaterial(Inventory inv, Material material) {
        int count = 0;
        for (ItemStack item : inv.all(material).values()) {
            count += item.getAmount();
        }
        return count;
    }

    public static ItemStack[] mergeStacks(Collection<? extends ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return null;
        }
        if (itemStacks.size() == 1) {
            return new ItemStack[]{itemStacks.iterator().next()};
        }
        int currentStackCount = 0;
        int leftOver = 0;
        ItemStack item = itemStacks.iterator().next();
        int stackSize = 64;
        Material material = item.getType();
        if (material == null) {
            return null;
        }
        ItemStack[] mergedStacks = new ItemStack[itemStacks.size() + 1];
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.getAmount() >= stackSize) {
                ItemStack tempItem = mergedStacks[currentStackCount];
                mergedStacks[currentStackCount++] = itemStack;
                mergedStacks[currentStackCount] = tempItem;
                continue;
            }
            ItemStack currentStack = mergedStacks[currentStackCount];
            if (currentStack == null) {
                mergedStacks[currentStackCount] = itemStack;
                continue;
            }
            int newAmount = currentStack.getAmount() + itemStack.getAmount();
            if (newAmount <= stackSize) {
                mergedStacks[currentStackCount].setAmount(newAmount);
                if (newAmount != stackSize) continue;
                ++currentStackCount;
                continue;
            }
            int tempLeftOver = newAmount - stackSize;
            mergedStacks[currentStackCount++].setAmount(newAmount - tempLeftOver);
            leftOver += tempLeftOver;
        }
        while (leftOver > 0) {
            if (leftOver >= stackSize) {
                mergedStacks[currentStackCount++] = new ItemStack(material, stackSize);
                leftOver -= stackSize;
                continue;
            }
            mergedStacks[currentStackCount++] = new ItemStack(material, leftOver);
            leftOver = 0;
        }
        int usedElements = 0;
        for (ItemStack stack : mergedStacks) {
            if (stack == null) break;
            ++usedElements;
        }
        if (usedElements != mergedStacks.length) {
            ItemStack[] itemStackArray = new ItemStack[usedElements];
            System.arraycopy(mergedStacks, 0, itemStackArray, 0, usedElements);
            mergedStacks = itemStackArray;
        }
        return mergedStacks;
    }

    public static int[] getVerticalSlots(int slot, int requiredSlots) {
        if (requiredSlots <= 1) {
            return new int[]{slot};
        }
        int[] verticalSlots = new int[requiredSlots];
        verticalSlots[0] = slot;
        if (slot < 9) {
            int currentSlot = slot;
            for (int invSlot = 1; invSlot < verticalSlots.length; ++invSlot) {
                currentSlot = currentSlot == slot ? 27 + slot : (currentSlot <= 17 ? 27 + (slot + 1) : (currentSlot -= 9));
                verticalSlots[invSlot] = currentSlot;
            }
        }
        return verticalSlots;
    }

    public static boolean canAddItem(Inventory inv, ItemStack item) {
        for (ItemStack itemLoop : inv) {
            if (itemLoop == null) {
                return true;
            }
            if (!itemLoop.isSimilar(item) || itemLoop.getAmount() + item.getAmount() >= itemLoop.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public static class ItemContainer {
        private Material material = null;
        private int damage = -1;
        private int amount = -1;
        private String displayName = null;
        private List<String> lore = null;
        private int isEnchanted = -1;
        private Map<Enchantment, Integer> enchantmentMap = null;
        private String owner = null;
        private static final Pattern PATTERN_SEPERATOR = Pattern.compile(":");

        public ItemStack replaceItemStack(ItemStack original, String playerName) {
            ItemMeta meta = original.getItemMeta();
            if (this.material != null) {
                original.setType(this.material);
            }
            if ((this.material == Material.SKULL_ITEM || this.material == Material.SKULL) && playerName != null) {
                ((SkullMeta)meta).setOwner(playerName);
            }
            if (this.damage != -1) {
                original.setDurability((short)this.damage);
            }
            if (this.amount != -1) {
                original.setAmount(this.amount);
            }
            if (this.displayName != null) {
                meta.setDisplayName(this.displayName);
            }
            if (meta.hasDisplayName() && playerName != null) {
                meta.setDisplayName(meta.getDisplayName().replace("{player}", playerName));
            }
            if (this.lore != null) {
                meta.setLore(this.lore);
            }
            if (this.isEnchanted != -1) {
                ItemStack itemStack = original = this.isEnchanted == 1 ? GUIUtil.addEnchantmentEffect(original) : GUIUtil.removeEnchantmentEffect(original);
            }
            if (this.enchantmentMap != null) {
                for (Enchantment enchantment : original.getEnchantments().keySet()) {
                    original.removeEnchantment(enchantment);
                }
                original.addEnchantments(this.enchantmentMap);
            }
            original.setItemMeta(meta);
            return original;
        }

        public ItemStack toItemStack(String playerName) {
            ItemStack itemStack = new ItemStack(this.material, this.amount, (short)this.damage);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (this.displayName != null) {
                itemMeta.setDisplayName(this.displayName);
            }
            if (this.lore != null) {
                itemMeta.setLore(this.lore);
            }
            if (this.enchantmentMap != null) {
                itemStack.addEnchantments(this.enchantmentMap);
            }
            itemStack.setItemMeta(itemMeta);
            return this.isEnchanted == 1 ? GUIUtil.addEnchantmentEffect(itemStack) : itemStack;
        }

        public static ItemContainer buildItemContainer(ConfigurationSection configurationSection, boolean errorChecking) {
            if (configurationSection == null) {
                BUtil.logError("One of the gui-item's configuration sections is invalid! Please check your configs for any blank sections.");
                return null;
            }
            Material material = null;
            String materialString = configurationSection.getString("material", null);
            if (materialString != null) {
                material = Material.getMaterial((String)materialString);
            }
            if (material == null && errorChecking) {
                BUtil.logError(GUIUtil.getErrorMessage(configurationSection, "material", materialString));
                return null;
            }
            int damage = configurationSection.getInt("damage", 0);
            int amount = configurationSection.getInt("amount", 1);
            String displayName = BUtil.translateColours(configurationSection.getString("title", ""));
            Map<Enchantment, Integer> enchantmentMap = null;
            int isEnchanted = -1;
            if (configurationSection.get("enchanted") != null) {
                if (configurationSection.isBoolean("enchanted")) {
                    isEnchanted = configurationSection.getBoolean("enchanted", false) ? 1 : 0;
                } else {
                    enchantmentMap = GUIUtil.addEnchantments(configurationSection.getStringList("enchanted"));
                }
            }
            List<String> lore = BUtil.translateColours(configurationSection.getStringList("lore"));
            String owner = null;
            if (configurationSection.contains("owner")) {
                owner = configurationSection.getString("owner");
            }
            return new ItemContainer(material, damage, amount, displayName, lore, isEnchanted, enchantmentMap, owner);
        }

        public static ItemContainer buildItemContainer(Map<String, Object> configurationMap, String prefix) {
            Material material;
            prefix = "";
            if (configurationMap == null || configurationMap.isEmpty()) {
                BUtil.logError("One of the gui-item's configuration sections is invalid! Please check your configs for any blank sections.");
                return null;
            }
            Object materialObj = configurationMap.get(prefix + "material");
            if (materialObj != null && !materialObj.toString().isEmpty()) {
                material = Material.getMaterial((String)materialObj.toString());
                if (material == null) {
                    BUtil.logError("Material: '" + materialObj.toString() + "' is not a valid material");
                    return null;
                }
            } else {
                if (materialObj != null) {
                    BUtil.logError("Material: '" + materialObj.toString() + "' is not a valid material");
                } else {
                    BUtil.logError("Material of reward was null!");
                }
                return null;
            }
            String displayName = "";
            Object displayNameObj = configurationMap.get(prefix + "displayname");
            if (displayNameObj != null && !displayNameObj.toString().isEmpty()) {
                displayName = BUtil.translateColours(displayNameObj.toString());
            }
            int damage = 0;
            Object damageObj = configurationMap.get(prefix + "damage");
            if (damageObj != null && Integer.parseInt(damageObj.toString()) > 0) {
                damage = Integer.parseInt(damageObj.toString());
            }
            List<String> lore = null;
            Object loreObj = configurationMap.get(prefix + "lore");
            if (loreObj != null && !((List)loreObj).isEmpty()) {
                lore = BUtil.translateColours((List)loreObj);
            }
            HashMap<Enchantment, Integer> enchantmentMap = null;
            int enchanted = -1;
            Object enchantmentObj = configurationMap.get(prefix + "enchanted");
            if (enchantmentObj instanceof List) {
                enchantmentMap = new HashMap<Enchantment, Integer>();
                if (!((List)enchantmentObj).isEmpty()) {
                    List enchantmentList = (List)enchantmentObj;
                    for (String enchantmentLine : enchantmentList) {
                        Enchantment enchantment = Enchantment.getByName((String)PATTERN_SEPERATOR.split(enchantmentLine)[0]);
                        if (enchantment == null) {
                            BUtil.logError("Enchantment '" + enchantmentLine + "' is not a valid enchantment configuration. Check your config.");
                            continue;
                        }
                        try {
                            enchantmentMap.put(enchantment, Integer.parseInt(PATTERN_SEPERATOR.split(enchantmentLine)[1]));
                        }
                        catch (NumberFormatException e) {
                            BUtil.logError("Enchantment " + enchantment.getName() + " has an invalid level");
                        }
                    }
                    if (enchantmentList.isEmpty()) {
                        enchantmentMap = null;
                    }
                }
            } else if (enchantmentObj instanceof Boolean) {
                enchanted = Boolean.parseBoolean(enchantmentObj.toString()) ? 1 : 0;
            }
            int amount = 1;
            Object amountObj = configurationMap.get(prefix + "amount");
            if (amountObj != null && Integer.parseInt(amountObj.toString()) > 0) {
                amount = Integer.parseInt(amountObj.toString());
            }
            String owner = null;
            Object ownerObj = configurationMap.get(prefix + "owner");
            if (ownerObj != null && !ownerObj.toString().isEmpty()) {
                owner = BUtil.translateColours(ownerObj.toString());
            }
            return new ItemContainer(material, damage, amount, displayName, lore, enchanted, enchantmentMap, owner);
        }

        @ConstructorProperties(value={"material", "damage", "amount", "displayName", "lore", "isEnchanted", "enchantmentMap", "owner"})
        public ItemContainer(Material material, int damage, int amount, String displayName, List<String> lore, int isEnchanted, Map<Enchantment, Integer> enchantmentMap, String owner) {
            this.material = material;
            this.damage = damage;
            this.amount = amount;
            this.displayName = displayName;
            this.lore = lore;
            this.isEnchanted = isEnchanted;
            this.enchantmentMap = enchantmentMap;
            this.owner = owner;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public int getIsEnchanted() {
            return this.isEnchanted;
        }

        public Map<Enchantment, Integer> getEnchantmentMap() {
            return this.enchantmentMap;
        }

        public String getOwner() {
            return this.owner;
        }
    }

    private static class CustomItemStack
    extends ItemStack {
        private Material material;
        private int amount;

        public CustomItemStack(Material material, int amount) {
            this.material = material;
            this.amount = amount;
        }

        public int getMaxStackSize() {
            return 64;
        }

        public int getAmount() {
            return this.amount;
        }

        public String toString() {
            return this.material.name() + " " + this.amount;
        }
    }
}

