/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.util.Vector;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class BUtil {
    private static boolean useConsoleColours = false;
    public static boolean DEBUG = false;
    private static final String PLUGIN_NAME = "BlivTrails";
    private static final String prefix = "&f[&bBlivTrails&f]&r ";
    private static final Logger log = Bukkit.getLogger();
    private static String playerPrefix = "\u00a78[\u00a7eBlivTrails\u00a78]\u00a7r ";
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(&|\u00a7|\u00c2\u00a7)[0-9a-fA-Fk-rK-R]");
    private static final Pattern colourPattern = Pattern.compile("(?i)&([0-9A-Fa-f-l-oL-OrR])");
    private static final BASE64Encoder base64Encoder = new BASE64Encoder();
    private static final BASE64Decoder base64Decoder = new BASE64Decoder();

    public static void createFirework(Location location, boolean instantExplosion, FireworkType fireworkType) {
        if (fireworkType == null) {
            fireworkType = FireworkType.CRATE_SPAWN;
        }
        Random rand = new Random(System.currentTimeMillis());
        FireworkEffect effect = FireworkEffect.builder().flicker(rand.nextBoolean()).withColor(new Color[]{fireworkType.getColour1(), fireworkType.getColour2()}).withFade(fireworkType.getColour3()).with(fireworkType.getType()).trail(rand.nextBoolean()).build();
        if (instantExplosion) {
            location.setY(location.getY() + 2.0);
        } else {
            Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
            FireworkMeta meta = firework.getFireworkMeta();
            meta.addEffect(effect);
            firework.setFireworkMeta(meta);
            firework.setVelocity(new Vector(0.0, 0.05, 0.0));
        }
    }

    public static String capitaliseFirst(String string) {
        return Character.toTitleCase(string.charAt(0)) + string.substring(1, string.length());
    }

    public static List<String> translateVariable(List<String> lines, String variable, String content) {
        if (lines == null) {
            return null;
        }
        if (!lines.isEmpty()) {
            for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
                lines.set(lineNum, lines.get(lineNum).replace(variable, content));
            }
        }
        return lines;
    }

    public static String stripColours(String toFix) {
        return FORMATTING_CODE_PATTERN.matcher(toFix).replaceAll("");
    }

    public static String translateConsoleColours(String toFix) {
        if (!useConsoleColours) {
            return FORMATTING_CODE_PATTERN.matcher(toFix).replaceAll("");
        }
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([a])").matcher(toFix).replaceAll("\u001b[32m\u001b[1m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([b])").matcher(toFix).replaceAll("\u001b[36m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([c])").matcher(toFix).replaceAll("\u001b[31m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([d])").matcher(toFix).replaceAll("\u001b[35m\u001b[1m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([e])").matcher(toFix).replaceAll("\u001b[33m\u001b[1m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([f])").matcher(toFix).replaceAll("\u001b[0m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([0])").matcher(toFix).replaceAll("\u001b[30m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([1])").matcher(toFix).replaceAll("\u001b[34m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([2])").matcher(toFix).replaceAll("\u001b[32m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([3])").matcher(toFix).replaceAll("\u001b[34m\u001b[1m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([4])").matcher(toFix).replaceAll("\u001b[31m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([5])").matcher(toFix).replaceAll("\u001b[35m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([6])").matcher(toFix).replaceAll("\u001b[33m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([7])").matcher(toFix).replaceAll("\u001b[37m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([8])").matcher(toFix).replaceAll("\u001b[30m\u001b[1m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([9])").matcher(toFix).replaceAll("\u001b[34m");
        toFix = Pattern.compile("(?i)(&|\u00c2\u00a7)([r])").matcher(toFix).replaceAll("\u001b[0m");
        toFix = toFix + "\u001b[0m";
        return toFix;
    }

    public static String translateColours(String toFix) {
        return colourPattern.matcher(toFix).replaceAll("\u00a7$1");
    }

    public static List<String> translateColours(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return null;
        }
        for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
            lines.set(lineNum, colourPattern.matcher(lines.get(lineNum)).replaceAll("\u00a7$1"));
        }
        return lines;
    }

    public static List<String> convertPlaceholders(List<String> lines, String[] placeholders, String[] content) {
        if (placeholders.length != content.length || lines == null) {
            if (lines != null) {
                BUtil.logError("Placeholder length does not match content length! Returning plain lines:\n" + lines.toString());
            }
            return lines;
        }
        lines = new ArrayList<String>(lines);
        for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
            String line = lines.get(lineNum);
            for (int index = 0; index < placeholders.length; ++index) {
                line = line.replace(placeholders[index], content[index]);
            }
            lines.set(lineNum, line);
        }
        return lines;
    }

    public static String convertPlaceholders(String line, String[] placeholders, String[] content) {
        if (placeholders.length != content.length) {
            return null;
        }
        for (int index = 0; index < placeholders.length; ++index) {
            line = line.replace(placeholders[index], content[index]);
        }
        return line;
    }

    public static void printSuccess(CommandSender sender, String message) {
        sender.sendMessage(playerPrefix + ChatColor.GREEN + BUtil.translateColours(message));
    }

    public static void printPlain(CommandSender sender, String message) {
        sender.sendMessage(playerPrefix + BUtil.translateColours(message));
    }

    public static void printInfo(CommandSender sender, String message) {
        sender.sendMessage(playerPrefix + ChatColor.YELLOW + BUtil.translateColours(message));
    }

    public static void printError(CommandSender sender, String message) {
        sender.sendMessage(playerPrefix + ChatColor.RED + BUtil.translateColours(message));
    }

    public static void printSelf(String message) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)"OhBlihv");
        if (offlinePlayer != null && offlinePlayer.isOnline()) {
            offlinePlayer.getPlayer().sendMessage(BUtil.translateColours(message));
        }
    }

    public static void printToOfflinePlayer(String playerName, String message) {
        if (playerName == null) {
            return;
        }
        BUtil.printToOfflinePlayer(Bukkit.getOfflinePlayer((String)playerName), message);
    }

    public static void printToOfflinePlayer(UUID uuid, String message) {
        if (uuid == null) {
            return;
        }
        BUtil.printToOfflinePlayer(Bukkit.getOfflinePlayer((UUID)uuid), message);
    }

    private static void printToOfflinePlayer(OfflinePlayer offlinePlayer, String message) {
        if (offlinePlayer != null && offlinePlayer.isOnline()) {
            offlinePlayer.getPlayer().sendMessage(message);
        }
    }

    public void broadcastPlain(String message) {
        Bukkit.broadcastMessage((String)message);
    }

    public static void logSuccess(String message) {
        log.log(Level.INFO, BUtil.translateConsoleColours("&f[&bBlivTrails&f]&r &2SUCCESS: &a" + message));
    }

    public static void logPlain(String message) {
        log.log(Level.INFO, BUtil.translateConsoleColours(prefix + message));
    }

    public static void logInfo(String message) {
        log.log(Level.INFO, BUtil.translateConsoleColours("&f[&bBlivTrails&f]&r &9INFO: &b" + message));
    }

    public static void logError(String message) {
        log.log(Level.WARNING, BUtil.translateConsoleColours("&f[&bBlivTrails&f]&r &4ERROR: &c" + message));
    }

    public static void logSevere(String message) {
        log.log(Level.SEVERE, BUtil.translateConsoleColours("&f[&bBlivTrails&f]&r &4SEVERE: &c" + message));
    }

    public static void logDebug(String message) {
        if (DEBUG) {
            log.log(Level.INFO, BUtil.translateConsoleColours("&f[&bBlivTrails&f]&r &2DEBUG: &a" + message));
        }
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        try {
            Method getOnlinePlayers = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]);
            if (getOnlinePlayers.getReturnType() == Collection.class) {
                return (Collection)getOnlinePlayers.invoke(null, new Object[0]);
            }
            return Arrays.asList((Player[])getOnlinePlayers.invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    public static String compressUUID(UUID uuid) {
        return base64Encoder.encode(BUtil.toBytes(uuid)).split("=")[0];
    }

    public static UUID deCompressUUID(String uuid) {
        try {
            return BUtil.fromBytes(base64Decoder.decodeBuffer(uuid.split(":")[0].concat("==")));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    public static UUID fromBytes(byte[] array) {
        if (array.length != 16) {
            throw new IllegalArgumentException("Illegal byte array length: " + array.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public static String trailConfigName(String particleString) {
        switch (particleString) {
            case "BARRIER": {
                return "barrier";
            }
            case "CLOUD": {
                return "cloud";
            }
            case "CRIT": {
                return "criticals";
            }
            case "CRIT_MAGIC": {
                return "criticals-magic";
            }
            case "DRIP_LAVA": {
                return "drip-lava";
            }
            case "DRIP_WATER": {
                return "drip-water";
            }
            case "ENCHANTMENT_TABLE": {
                return "enchant";
            }
            case "EXPLOSION_NORMAL": {
                return "explosion-smoke";
            }
            case "FIREWORKS_SPARK": {
                return "firework";
            }
            case "FLAME": {
                return "flame";
            }
            case "HEART": {
                return "hearts";
            }
            case "LAVA": {
                return "lava";
            }
            case "NOTE": {
                return "note";
            }
            case "PORTAL": {
                return "portal";
            }
            case "REDSTONE": {
                return "redstone";
            }
            case "SLIME": {
                return "slime";
            }
            case "SMOKE_LARGE": {
                return "smoke";
            }
            case "SNOW_SHOVEL": {
                return "snow-shovel";
            }
            case "SNOWBALL": {
                return "snow-ball";
            }
            case "SPELL": {
                return "spell";
            }
            case "SPELL_INSTANT": {
                return "spell-instant";
            }
            case "SPELL_MOB": {
                return "spell-mob";
            }
            case "SPELL_WITCH": {
                return "spell-witch";
            }
            case "VILLAGER_ANGRY": {
                return "angry-villager";
            }
            case "VILLAGER_HAPPY": {
                return "happy-villager";
            }
            case "TOWN_AURA": {
                return "town-aura";
            }
            case "WATER_DROP": {
                return "water-drop";
            }
            case "WATER_SPLASH": {
                return "water-splash";
            }
            case "END_ROD": {
                return "end-rod";
            }
            case "DRAGON_BREATH": {
                return "dragon-breath";
            }
            case "DAMAGE_INDICATOR": {
                return "damage-indicator";
            }
            case "SWEEP_ATTACK": {
                return "sweep-attack";
            }
        }
        return "";
    }

    public static String intToColour(int colour) {
        switch (colour) {
            case 1: {
                return "red";
            }
            case 2: {
                return "darkgreen";
            }
            case 3: {
                return "brown";
            }
            case 4: {
                return "darkblue";
            }
            case 5: {
                return "purple";
            }
            case 6: {
                return "cyan";
            }
            case 7: {
                return "lightgrey";
            }
            case 8: {
                return "grey";
            }
            case 9: {
                return "pink";
            }
            case 10: {
                return "lime";
            }
            case 11: {
                return "yellow";
            }
            case 12: {
                return "lightblue";
            }
            case 13: {
                return "magenta";
            }
            case 14: {
                return "orange";
            }
            case 16: {
                return "random";
            }
        }
        return "black";
    }

    public static void setPlayerPrefix(String playerPrefix) {
        BUtil.playerPrefix = playerPrefix;
    }

    public static enum FireworkType {
        CRATE_SPAWN(FireworkEffect.Type.BALL, Color.ORANGE, Color.WHITE, Color.YELLOW),
        OPEN_CRATE(FireworkEffect.Type.BALL, Color.GRAY, Color.WHITE, Color.BLACK),
        PVP_DEATH(FireworkEffect.Type.BALL, Color.RED, Color.ORANGE, Color.RED);

        private FireworkEffect.Type type;
        private Color colour1;
        private Color colour2;
        private Color colour3;

        private FireworkType(FireworkEffect.Type type, Color colour1, Color colour2, Color colour3) {
            this.type = type;
            this.colour1 = colour1;
            this.colour2 = colour2;
            this.colour3 = colour3;
        }

        public FireworkEffect.Type getType() {
            return this.type;
        }

        public Color getColour1() {
            return this.colour1;
        }

        public Color getColour2() {
            return this.colour2;
        }

        public Color getColour3() {
            return this.colour3;
        }
    }
}

