/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.storage;

import java.util.UUID;
import net.auscraft.BlivTrails.shade.ormlite.field.DatabaseField;
import net.auscraft.BlivTrails.shade.ormlite.table.DatabaseTable;
import net.auscraft.BlivTrails.storage.ParticleStorage;
import net.auscraft.BlivTrails.storage.mysql.ByteArray;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.entity.Player;

@DatabaseTable(tableName="bliv_trails", daoClass=ParticleStorage.class)
public class ParticleData {
    @DatabaseField(id=true, persisterClass=ByteArray.class, columnDefinition="BINARY(16) NOT NULL")
    private byte[] id;
    @DatabaseField(width=50, columnDefinition="VARCHAR(50) NOT NULL")
    private String particle;
    @DatabaseField(columnDefinition="INT(11) NOT NULL")
    private int type;
    @DatabaseField(columnDefinition="INT(11) NOT NULL")
    private int length;
    @DatabaseField(columnDefinition="INT(11) NOT NULL")
    private int height;
    @DatabaseField(columnDefinition="INT(11) NOT NULL")
    private int colour;
    private UUID uuid = null;

    ParticleData() {
    }

    public ParticleData(Player player) {
        this.id = BUtil.toBytes(player.getUniqueId());
        this.uuid = player.getUniqueId();
    }

    public ParticleData(byte[] uuidBytes, String particle, int type, int length, int height, int colour) {
        this.id = uuidBytes;
        this.particle = particle;
        this.type = type;
        this.length = length;
        this.height = height;
        this.colour = colour;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = BUtil.fromBytes(this.id);
        }
        return this.uuid;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getParticle() {
        return this.particle;
    }

    public void setParticle(String particle) {
        this.particle = particle;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }
}

