/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.stmt.mapped;

import java.sql.SQLException;
import net.auscraft.BlivTrails.shade.ormlite.dao.ObjectCache;
import net.auscraft.BlivTrails.shade.ormlite.db.DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.misc.SqlExceptionUtil;
import net.auscraft.BlivTrails.shade.ormlite.stmt.mapped.BaseMappedStatement;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseConnection;
import net.auscraft.BlivTrails.shade.ormlite.table.TableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedUpdateId<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedUpdateId(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
    }

    public int execute(DatabaseConnection databaseConnection, T data, ID newId, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = new Object[]{this.convertIdToFieldObject(newId), this.extractIdToFieldObject(data)};
            int rowC = databaseConnection.update(this.statement, args, this.argFieldTypes);
            if (rowC > 0) {
                Object oldId;
                Object obj;
                if (objectCache != null && (obj = objectCache.updateId(this.clazz, oldId = this.idField.extractJavaFieldValue(data), newId)) != null && obj != data) {
                    this.idField.assignField(obj, newId, false, objectCache);
                }
                this.idField.assignField(data, newId, false, objectCache);
            }
            logger.debug("updating-id with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("updating-id arguments: {}", (Object)args);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run update-id stmt on object " + data + ": " + this.statement, e);
        }
    }

    public static <T, ID> MappedUpdateId<T, ID> build(DatabaseType databaseType, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update-id in " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        MappedUpdateId.appendTableName(databaseType, sb, "UPDATE ", tableInfo.getTableName());
        sb.append("SET ");
        MappedUpdateId.appendFieldColumnName(databaseType, sb, idField, null);
        sb.append("= ? ");
        MappedUpdateId.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedUpdateId<T, ID>(tableInfo, sb.toString(), new FieldType[]{idField, idField});
    }

    private Object extractIdToFieldObject(T data) throws SQLException {
        return this.idField.extractJavaFieldToSqlArgValue(data);
    }
}

