/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.stmt.mapped;

import java.sql.SQLException;
import net.auscraft.BlivTrails.shade.ormlite.dao.ObjectCache;
import net.auscraft.BlivTrails.shade.ormlite.db.DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.misc.SqlExceptionUtil;
import net.auscraft.BlivTrails.shade.ormlite.stmt.mapped.BaseMappedStatement;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseConnection;
import net.auscraft.BlivTrails.shade.ormlite.table.TableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedDelete<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDelete(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> MappedDelete<T, ID> build(DatabaseType databaseType, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete from " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        MappedDelete.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo.getTableName());
        MappedDelete.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedDelete<T, ID>(tableInfo, sb.toString(), new FieldType[]{idField});
    }

    public int delete(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(data);
            int rowC = databaseConnection.delete(this.statement, args, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", (Object)args);
            }
            if (rowC > 0 && objectCache != null) {
                Object id = this.idField.extractJavaFieldToSqlArgValue(data);
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run delete stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int deleteById(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = new Object[]{this.convertIdToFieldObject(id)};
            int rowC = databaseConnection.delete(this.statement, args, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", (Object)args);
            }
            if (rowC > 0 && objectCache != null) {
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run deleteById stmt on id " + id + ": " + this.statement, e);
        }
    }
}

