/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.stmt;

import java.sql.SQLException;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.stmt.ArgumentHolder;

public abstract class BaseArgumentHolder
implements ArgumentHolder {
    private String columnName = null;
    private FieldType fieldType = null;
    private SqlType sqlType = null;

    public BaseArgumentHolder() {
    }

    public BaseArgumentHolder(String columName) {
        this.columnName = columName;
    }

    public BaseArgumentHolder(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    protected abstract Object getValue();

    public abstract void setValue(Object var1);

    protected abstract boolean isValueSet();

    public String getColumnName() {
        return this.columnName;
    }

    public void setMetaInfo(String columnName) {
        if (this.columnName != null && !this.columnName.equals(columnName)) {
            throw new IllegalArgumentException("Column name cannot be set twice from " + this.columnName + " to " + columnName + ".  Using a SelectArg twice in query with different columns?");
        }
        this.columnName = columnName;
    }

    public void setMetaInfo(FieldType fieldType) {
        if (this.fieldType != null && this.fieldType != fieldType) {
            throw new IllegalArgumentException("FieldType name cannot be set twice from " + this.fieldType + " to " + fieldType + ".  Using a SelectArg twice in query with different columns?");
        }
        this.fieldType = fieldType;
    }

    public void setMetaInfo(String columnName, FieldType fieldType) {
        this.setMetaInfo(columnName);
        this.setMetaInfo(fieldType);
    }

    public Object getSqlArgValue() throws SQLException {
        if (!this.isValueSet()) {
            throw new SQLException("Column value has not been set for " + this.columnName);
        }
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (this.fieldType == null) {
            return value;
        }
        if (this.fieldType.isForeign() && this.fieldType.getType() == value.getClass()) {
            FieldType idFieldType = this.fieldType.getForeignIdField();
            return idFieldType.extractJavaFieldValue(value);
        }
        return this.fieldType.convertJavaFieldToSqlArgValue(value);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        if (!this.isValueSet()) {
            return "[unset]";
        }
        try {
            Object val = this.getSqlArgValue();
            if (val == null) {
                return "[null]";
            }
            return val.toString();
        }
        catch (SQLException e) {
            return "[could not get value: " + e + "]";
        }
    }
}

