/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.auscraft.BlivTrails.shade.ormlite.db.DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.DatabaseTypeUtils;
import net.auscraft.BlivTrails.shade.ormlite.jdbc.JdbcDatabaseConnection;
import net.auscraft.BlivTrails.shade.ormlite.logger.Logger;
import net.auscraft.BlivTrails.shade.ormlite.logger.LoggerFactory;
import net.auscraft.BlivTrails.shade.ormlite.support.BaseConnectionSource;
import net.auscraft.BlivTrails.shade.ormlite.support.ConnectionSource;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseConnection;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseConnectionProxyFactory;

public class JdbcConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcConnectionSource.class);
    private String url;
    private String username;
    private String password;
    private DatabaseConnection connection;
    protected DatabaseType databaseType;
    protected boolean initialized = false;
    private static DatabaseConnectionProxyFactory connectionProxyFactory;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.databaseType = databaseType;
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.url == null) {
            throw new SQLException("url was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.url);
        }
        this.databaseType.loadDriver();
        this.databaseType.setDriver(DriverManager.getDriver(this.url));
        this.initialized = true;
    }

    public void close() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            this.connection.close();
            logger.debug("closed connection #{}", this.connection.hashCode());
            this.connection = null;
        }
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        this.connection = this.makeConnection(logger);
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return true;
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
    }

    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.databaseType;
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        JdbcConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }

    protected DatabaseConnection makeConnection(Logger logger) throws SQLException {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        DatabaseConnection connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        connection.setAutoCommit(true);
        if (connectionProxyFactory != null) {
            connection = connectionProxyFactory.createProxy(connection);
        }
        logger.debug("opened connection to {} got #{}", (Object)this.url, (Object)connection.hashCode());
        return connection;
    }
}

