/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.auscraft.BlivTrails.shade.ormlite.dao.ObjectCache;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.jdbc.JdbcDatabaseResults;
import net.auscraft.BlivTrails.shade.ormlite.jdbc.TypeValMapper;
import net.auscraft.BlivTrails.shade.ormlite.stmt.StatementBuilder;
import net.auscraft.BlivTrails.shade.ormlite.support.CompiledStatement;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

public class JdbcCompiledStatement
implements CompiledStatement {
    private final PreparedStatement preparedStatement;
    private final StatementBuilder.StatementType type;
    private ResultSetMetaData metaData = null;

    public JdbcCompiledStatement(PreparedStatement preparedStatement, StatementBuilder.StatementType type) {
        this.preparedStatement = preparedStatement;
        this.type = type;
    }

    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int column) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnName(column + 1);
    }

    public int runUpdate() throws SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + (Object)((Object)this.type) + " statement");
        }
        return this.preparedStatement.executeUpdate();
    }

    public DatabaseResults runQuery(ObjectCache objectCache) throws SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + (Object)((Object)this.type) + " statement");
        }
        return new JdbcDatabaseResults(this.preparedStatement, this.preparedStatement.executeQuery(), objectCache);
    }

    public int runExecute() throws SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + (Object)((Object)this.type) + " statement");
        }
        this.preparedStatement.execute();
        return this.preparedStatement.getUpdateCount();
    }

    public void close() throws SQLException {
        this.preparedStatement.close();
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws SQLException {
        if (obj == null) {
            this.preparedStatement.setNull(parameterIndex + 1, TypeValMapper.getTypeValForSqlType(sqlType));
        } else {
            this.preparedStatement.setObject(parameterIndex + 1, obj, TypeValMapper.getTypeValForSqlType(sqlType));
        }
    }

    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    public void setQueryTimeout(long millis) throws SQLException {
        this.preparedStatement.setQueryTimeout(Long.valueOf(millis).intValue() / 1000);
    }

    boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }
}

