/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.field.types;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.field.types.BaseDateType;
import net.auscraft.BlivTrails.shade.ormlite.field.types.DateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateType
extends DateType {
    private static final SqlDateType singleTon = new SqlDateType();
    private static final BaseDateType.DateStringFormatConfig sqlDateFormatConfig = new BaseDateType.DateStringFormatConfig("yyyy-MM-dd");

    public static SqlDateType getSingleton() {
        return singleTon;
    }

    private SqlDateType() {
        super(SqlType.DATE, new Class[]{Date.class});
    }

    protected SqlDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        Timestamp value = (Timestamp)sqlArg;
        return new Date(value.getTime());
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Date date = (Date)javaObject;
        return new Timestamp(date.getTime());
    }

    @Override
    protected BaseDateType.DateStringFormatConfig getDefaultDateFormatConfig() {
        return sqlDateFormatConfig;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
        return this.sqlArgToJava(fieldType, Timestamp.valueOf(stringValue), columnPos);
    }

    @Override
    public boolean isValidForField(Field field) {
        return field.getType() == Date.class;
    }
}

