/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.field.types;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.field.types.BaseDateType;
import net.auscraft.BlivTrails.shade.ormlite.misc.SqlExceptionUtil;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateStringType
extends BaseDateType {
    public static int DEFAULT_WIDTH = 50;
    private static final DateStringType singleTon = new DateStringType();

    public static DateStringType getSingleton() {
        return singleTon;
    }

    private DateStringType() {
        super(SqlType.STRING, new Class[0]);
    }

    protected DateStringType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        BaseDateType.DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType, defaultDateFormatConfig);
        try {
            return DateStringType.normalizeDateString(formatConfig, defaultStr);
        }
        catch (ParseException e) {
            throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default date-string '" + defaultStr + "' using '" + formatConfig + "'", e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        String value = (String)sqlArg;
        BaseDateType.DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType, defaultDateFormatConfig);
        try {
            return DateStringType.parseDateString(formatConfig, value);
        }
        catch (ParseException e) {
            throw SqlExceptionUtil.create("Problems with column " + columnPos + " parsing date-string '" + value + "' using '" + formatConfig + "'", e);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        DateFormat dateFormat = DateStringType.convertDateStringConfig(fieldType, defaultDateFormatConfig).getDateFormat();
        return dateFormat.format((Date)obj);
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) {
        String format = fieldType.getFormat();
        if (format == null) {
            return defaultDateFormatConfig;
        }
        return new BaseDateType.DateStringFormatConfig(format);
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        return this.sqlArgToJava(fieldType, stringValue, columnPos);
    }

    @Override
    public Class<?> getPrimaryClass() {
        return byte[].class;
    }
}

