/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.field.types;

import java.sql.SQLException;
import java.util.Date;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.field.types.BaseDateType;
import net.auscraft.BlivTrails.shade.ormlite.misc.SqlExceptionUtil;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateLongType
extends BaseDateType {
    private static final DateLongType singleTon = new DateLongType();

    public static DateLongType getSingleton() {
        return singleTon;
    }

    private DateLongType() {
        super(SqlType.LONG, new Class[0]);
    }

    protected DateLongType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Long.parseLong(defaultStr);
        }
        catch (NumberFormatException e) {
            throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default date-long value: " + defaultStr, e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getLong(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return new Date((Long)sqlArg);
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Date date = (Date)obj;
        return date.getTime();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
        return this.sqlArgToJava(fieldType, Long.parseLong(stringValue), columnPos);
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Date.class;
    }
}

