/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.db;

import java.sql.SQLException;
import java.util.List;
import net.auscraft.BlivTrails.shade.ormlite.db.BaseDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.field.BaseFieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.DataPersister;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlServerDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "sqlserver";
    private static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DATABASE_NAME = "SQL Server";
    private static final FieldConverter byteConverter = new ByteFieldConverter();
    private static final FieldConverter booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
            case BYTE: {
                return byteConverter;
            }
        }
        return super.getFieldConverter(dataType);
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BIT");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DATETIME");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        if (fieldType.isAllowGeneratedIdInsert()) {
            StringBuilder identityInsertSb = new StringBuilder();
            identityInsertSb.append("SET IDENTITY_INSERT ");
            this.appendEscapedEntityName(identityInsertSb, tableName);
            identityInsertSb.append(" ON");
            statementsAfter.add(identityInsertSb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isLimitAfterSelect() {
        return true;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("TOP ").append(limit).append(' ');
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return false;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsNegative() {
        return true;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }

    private static class ByteFieldConverter
    extends BaseFieldConverter {
        private ByteFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BYTE;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getShort(columnPos);
        }

        public Object sqlArgToJava(FieldType fieldType, Object sqlObject, int columnPos) {
            short shortVal = (Short)sqlObject;
            if (shortVal < -128) {
                return (byte)-128;
            }
            if (shortVal > 127) {
                return (byte)127;
            }
            return (byte)shortVal;
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            byte byteVal = (Byte)javaObject;
            return (short)byteVal;
        }

        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Short.parseShort(stringValue), columnPos);
        }
    }
}

