/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.db;

import java.sql.SQLException;
import java.util.List;
import net.auscraft.BlivTrails.shade.ormlite.db.BaseDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.field.BaseFieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.DataPersister;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "oracle";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String DATABASE_NAME = "Oracle";
    private static final String BOOLEAN_INTEGER_FORMAT = "integer";
    private static final FieldConverter booleanConverter = new BooleanFieldConverter();

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    protected void appendStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("VARCHAR2(").append(fieldWidth).append(")");
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMERIC");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    @Override
    protected void appendBigDecimalNumericType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMBER(*," + fieldWidth + ")");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (BOOLEAN_INTEGER_FORMAT.equalsIgnoreCase(fieldType.getFormat())) {
            sb.append("INTEGER");
        } else {
            sb.append("CHAR(1)");
        }
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
        }
        return super.getFieldConverter(dataPersister);
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String seqName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, seqName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT ");
        this.appendEscapedEntityName(sb, sequenceName);
        sb.append(".nextval FROM dual");
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return false;
    }

    @Override
    public boolean isBatchUseTransaction() {
        return true;
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    protected static class BooleanFieldConverter
    extends BaseFieldConverter {
        private static final String TRUE_FALSE_FORMAT = "10";

        protected BooleanFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.CHAR;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            return this.javaToSqlArg(fieldType, Boolean.parseBoolean(defaultStr));
        }

        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            String format = this.getTrueFalseFormat(fieldType);
            if (format == OracleDatabaseType.BOOLEAN_INTEGER_FORMAT) {
                return (Boolean)obj != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            return Character.valueOf((Boolean)obj != false ? format.charAt(0) : format.charAt(1));
        }

        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return Character.valueOf(results.getChar(columnPos));
        }

        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
            String format = this.getTrueFalseFormat(fieldType);
            if (format == OracleDatabaseType.BOOLEAN_INTEGER_FORMAT) {
                return (Integer)sqlArg == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return ((Character)sqlArg).charValue() == format.charAt(0) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
            if (stringValue.length() == 0) {
                return Boolean.FALSE;
            }
            return this.sqlArgToJava(fieldType, Character.valueOf(stringValue.charAt(0)), columnPos);
        }

        private String getTrueFalseFormat(FieldType fieldType) throws SQLException {
            String format = fieldType.getFormat();
            if (format == null) {
                return TRUE_FALSE_FORMAT;
            }
            if (format.equalsIgnoreCase(OracleDatabaseType.BOOLEAN_INTEGER_FORMAT)) {
                return OracleDatabaseType.BOOLEAN_INTEGER_FORMAT;
            }
            if (format.length() == 2 && format.charAt(0) != format.charAt(1)) {
                return format;
            }
            throw new SQLException("Invalid boolean format must have 2 different characters that represent true/false like \"10\": " + format);
        }
    }
}

