/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import net.auscraft.BlivTrails.shade.ormlite.db.BaseDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.field.BaseFieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.DataPersister;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldConverter;
import net.auscraft.BlivTrails.shade.ormlite.field.FieldType;
import net.auscraft.BlivTrails.shade.ormlite.field.SqlType;
import net.auscraft.BlivTrails.shade.ormlite.misc.SqlExceptionUtil;
import net.auscraft.BlivTrails.shade.ormlite.support.DatabaseResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyEmbeddedDatabaseType
extends BaseDatabaseType {
    protected static final String DATABASE_URL_PORTION = "derby";
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DATABASE_NAME = "Derby";
    private static FieldConverter serializableConverter;
    private static FieldConverter booleanConverter;
    private static FieldConverter charConverter;

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        if (!DATABASE_URL_PORTION.equals(dbTypePart)) {
            return false;
        }
        String[] parts = url.split(":");
        return parts.length >= 3 && !parts[2].startsWith("//");
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                if (booleanConverter == null) {
                    booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();
                }
                return booleanConverter;
            }
            case CHAR: {
                if (charConverter == null) {
                    charConverter = new CharFieldConverter();
                }
                return charConverter;
            }
            case SERIALIZABLE: {
                if (serializableConverter == null) {
                    serializableConverter = new SerializableFieldConverter();
                }
                return serializableConverter;
            }
        }
        return super.getFieldConverter(dataType);
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR");
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        sb.append("OFFSET ").append(offset).append(" ROWS ");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendCharType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR FOR BIT DATA");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isLimitSqlSupported() {
        return false;
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("VALUES(DEFAULT)");
    }

    private static class CharFieldConverter
    extends BaseFieldConverter {
        private CharFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.INTEGER;
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            char character = ((Character)javaObject).charValue();
            return (int)character;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            if (defaultStr.length() != 1) {
                throw new SQLException("Problems with field " + fieldType + ", default string to long: '" + defaultStr + "'");
            }
            return (int)defaultStr.charAt(0);
        }

        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
            int intVal = (Integer)sqlArg;
            return Character.valueOf((char)intVal);
        }

        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Integer.parseInt(stringValue), columnPos);
        }
    }

    private static class SerializableFieldConverter
    extends BaseFieldConverter {
        private SerializableFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BLOB;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            throw new SQLException("Default values for serializable types are not supported");
        }

        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getBlobStream(columnPos);
        }

        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
            InputStream stream = (InputStream)sqlArg;
            try {
                ObjectInputStream objInStream = new ObjectInputStream(stream);
                Object object = objInStream.readObject();
                return object;
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not read serialized object from result blob", e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
                objOutStream.writeObject(javaObject);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not write serialized object to output stream", e);
            }
            return new SerialBlob(outStream.toByteArray());
        }

        public boolean isStreamType() {
            return true;
        }

        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
            throw new SQLException("Parsing string value for serializable types is not supported");
        }
    }
}

