/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.shade.ormlite.db;

import java.util.ArrayList;
import java.util.List;
import net.auscraft.BlivTrails.shade.ormlite.db.DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.Db2DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.DerbyClientServerDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.DerbyEmbeddedDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.GenericOdbcDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.H2DatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.HsqldbDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.MysqlDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.NetezzaDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.OracleDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.PostgresDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.SqlServerDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.SqlServerJtdsDatabaseType;
import net.auscraft.BlivTrails.shade.ormlite.db.SqliteDatabaseType;

public class DatabaseTypeUtils {
    private static List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();

    private DatabaseTypeUtils() {
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        for (DatabaseType databaseType : databaseTypes) {
            if (!databaseType.isDatabaseUrlThisType(databaseUrl, dbTypePart)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        databaseTypes.add(new Db2DatabaseType());
        databaseTypes.add(new DerbyClientServerDatabaseType());
        databaseTypes.add(new DerbyEmbeddedDatabaseType());
        databaseTypes.add(new GenericOdbcDatabaseType());
        databaseTypes.add(new H2DatabaseType());
        databaseTypes.add(new HsqldbDatabaseType());
        databaseTypes.add(new MysqlDatabaseType());
        databaseTypes.add(new NetezzaDatabaseType());
        databaseTypes.add(new OracleDatabaseType());
        databaseTypes.add(new PostgresDatabaseType());
        databaseTypes.add(new SqliteDatabaseType());
        databaseTypes.add(new SqlServerDatabaseType());
        databaseTypes.add(new SqlServerJtdsDatabaseType());
    }
}

