/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.runnables;

import java.beans.ConstructorProperties;
import net.auscraft.BlivTrails.BlivTrails;
import net.auscraft.BlivTrails.OptionType;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.TrailDefaults;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TrailRunnable
implements Runnable {
    private static final BlivTrails plugin = BlivTrails.getInstance();
    private Player player;
    double[] heightCfg = new double[3];
    double[] variationCfg = new double[3];
    double sprayCfg;
    ParticleEffect particle = null;
    ParticleEffect.ParticleColor data = null;
    double height = 0.0;
    float xOff = 0.0f;
    float yOff = 0.0f;
    float zOff = 0.0f;
    float speed = 0.0f;
    OptionType length = OptionType.NONE;
    OptionType type = OptionType.NONE;
    int colour = 0;

    public TrailRunnable(Player player, PlayerConfig pcfg, double[] option) {
        this.player = player;
        this.particle = pcfg.getParticle();
        TrailDefaults.ParticleDefaultStorage particleStorage = TrailDefaults.getDefaults(this.particle);
        this.heightCfg[0] = particleStorage.getFeetLocation() != 0.0 ? particleStorage.getFeetLocation() : option[4];
        this.heightCfg[1] = particleStorage.getWaistLocation() != 0.0 ? particleStorage.getWaistLocation() : option[5];
        this.heightCfg[2] = particleStorage.getHaloLocation() != 0.0 ? particleStorage.getHaloLocation() : option[6];
        this.variationCfg[0] = particleStorage.getXVariation() != 0.0 ? particleStorage.getXVariation() : option[0];
        this.variationCfg[1] = particleStorage.getYVariation() != 0.0 ? particleStorage.getYVariation() : option[1];
        this.variationCfg[2] = particleStorage.getZVariation() != 0.0 ? particleStorage.getZVariation() : option[2];
        this.sprayCfg = particleStorage.getSprayVariation() != 0.0 ? particleStorage.getSprayVariation() : option[3];
        this.length = pcfg.getLength();
        this.type = pcfg.getType();
        if (this.type != OptionType.TYPE_RANDOM) {
            this.height = this.heightCfg[pcfg.getHeight().getCfgId()];
        }
        this.colour = pcfg.getColour();
        if (this.particle == ParticleEffect.NOTE) {
            switch (this.colour) {
                case 1: {
                    this.data = new ParticleEffect.NoteColor(7);
                    break;
                }
                case 2: {
                    this.data = new ParticleEffect.NoteColor(20);
                    break;
                }
                case 4: {
                    this.data = new ParticleEffect.NoteColor(15);
                    break;
                }
                case 5: {
                    this.data = new ParticleEffect.NoteColor(12);
                    break;
                }
                case 6: {
                    this.data = new ParticleEffect.NoteColor(18);
                    break;
                }
                case 9: {
                    this.data = new ParticleEffect.NoteColor(10);
                    break;
                }
                case 10: {
                    this.data = new ParticleEffect.NoteColor(24);
                    break;
                }
                case 11: {
                    this.data = new ParticleEffect.NoteColor(3);
                    break;
                }
                case 12: {
                    this.data = new ParticleEffect.NoteColor(17);
                    break;
                }
                case 13: {
                    this.data = new ParticleEffect.NoteColor(11);
                    break;
                }
                case 14: {
                    this.data = new ParticleEffect.NoteColor(5);
                    break;
                }
                case 16: {
                    this.data = new ParticleEffect.NoteColor(BlivTrails.rand.nextInt(24));
                    break;
                }
                default: {
                    this.data = new ParticleEffect.NoteColor(24);
                    break;
                }
            }
        } else {
            switch (this.colour) {
                case 0: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 0, 0);
                    break;
                }
                case 1: {
                    this.data = new ParticleEffect.OrdinaryColor(255, 0, 0);
                    break;
                }
                case 2: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 128, 0);
                    break;
                }
                case 3: {
                    this.data = new ParticleEffect.OrdinaryColor(128, 128, 0);
                    break;
                }
                case 4: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 0, 255);
                    break;
                }
                case 5: {
                    this.data = new ParticleEffect.OrdinaryColor(128, 0, 128);
                    break;
                }
                case 6: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 128, 128);
                    break;
                }
                case 7: {
                    this.data = new ParticleEffect.OrdinaryColor(192, 192, 192);
                    break;
                }
                case 8: {
                    this.data = new ParticleEffect.OrdinaryColor(128, 128, 128);
                    break;
                }
                case 9: {
                    this.data = new ParticleEffect.OrdinaryColor(235, 69, 207);
                    break;
                }
                case 10: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 255, 0);
                    break;
                }
                case 11: {
                    this.data = new ParticleEffect.OrdinaryColor(255, 255, 0);
                    break;
                }
                case 12: {
                    this.data = new ParticleEffect.OrdinaryColor(0, 255, 255);
                    break;
                }
                case 13: {
                    this.data = new ParticleEffect.OrdinaryColor(255, 0, 255);
                    break;
                }
                case 14: {
                    this.data = new ParticleEffect.OrdinaryColor(255, 128, 0);
                    break;
                }
                case 16: {
                    this.data = new ParticleEffect.OrdinaryColor(BlivTrails.rand.nextInt(255), BlivTrails.rand.nextInt(255), BlivTrails.rand.nextInt(255));
                    break;
                }
                default: {
                    this.data = new ParticleEffect.OrdinaryColor(255, 255, 255);
                }
            }
        }
    }

    @Override
    public void run() {
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(this.player.getUniqueId());
        if (playerConfig == null) {
            BUtil.logError("Attempted to spawn particle for unloaded player " + this.player.getName());
            return;
        }
        if (!playerConfig.canSpawnParticle()) {
            return;
        }
        if (this.type == OptionType.TYPE_RANDOM) {
            int xDir = 1;
            int yDir = 1;
            int zDir = 1;
            if (BlivTrails.rand.nextBoolean()) {
                xDir = -1;
            }
            if (BlivTrails.rand.nextBoolean()) {
                yDir = -1;
            }
            if (BlivTrails.rand.nextBoolean()) {
                zDir = -1;
            }
            this.xOff = (float)((double)BlivTrails.rand.nextFloat() * this.variationCfg[0] * (double)xDir);
            this.yOff = (float)((double)BlivTrails.rand.nextFloat() * this.variationCfg[1] * (double)yDir);
            this.zOff = (float)((double)BlivTrails.rand.nextFloat() * this.variationCfg[2] * (double)zDir);
        } else if (this.type == OptionType.TYPE_DYNAMIC) {
            this.speed = (float)((double)BlivTrails.rand.nextFloat() / 20.0 * this.sprayCfg);
        }
        try {
            if (this.particle.hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
                if (this.particle == ParticleEffect.NOTE) {
                    if (this.colour == 16) {
                        this.data = new ParticleEffect.NoteColor(BlivTrails.rand.nextInt(24));
                    }
                } else if (this.colour == 16) {
                    this.data = new ParticleEffect.OrdinaryColor(BlivTrails.rand.nextInt(255), BlivTrails.rand.nextInt(255), BlivTrails.rand.nextInt(255));
                }
                if (this.type == OptionType.TYPE_RANDOM) {
                    this.particle.display(this.data, this.player.getLocation().add((double)this.xOff, (double)this.yOff, (double)this.zOff), 64.0);
                } else {
                    this.particle.display(this.data, this.player.getLocation().add(0.0, this.height, 0.0), 64.0);
                }
            } else if (this.particle == ParticleEffect.DRAGON_BREATH) {
                this.player.getWorld().spawnParticle(Particle.valueOf((String)this.particle.name()), this.player.getLocation().add(0.0, this.height, 0.0), 1, (double)this.xOff, (double)this.yOff, (double)this.zOff, (double)this.speed);
            } else {
                this.particle.display(this.xOff, this.yOff, this.zOff, this.speed, 1, this.player.getLocation().add(0.0, this.height, 0.0), 64.0);
            }
            if (this.length.getCfgId() > 1) {
                for (int i = 1; i < this.length.getCfgId() + 1; ++i) {
                    if (this.particle.hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
                        if (this.type == OptionType.TYPE_RANDOM) {
                            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, (Runnable)new DisplayColourableRunnable(this.particle, this.data, this.player.getLocation().add((double)this.xOff, (double)this.yOff, (double)this.zOff)), (long)(i * 5));
                            continue;
                        }
                        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, (Runnable)new DisplayColourableRunnable(this.particle, this.data, this.player.getLocation().add(0.0, this.height, 0.0)), (long)(i * 5));
                        continue;
                    }
                    if (this.particle == ParticleEffect.DRAGON_BREATH) {
                        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, (Runnable)new DragonsBreathRunnable(this.particle, this.xOff, this.yOff, this.zOff, this.speed, this.player.getLocation().add(0.0, this.height, 0.0)), (long)(i * 5));
                        continue;
                    }
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, (Runnable)new DisplayRegularRunnable(this.particle, this.xOff, this.yOff, this.zOff, this.speed, this.player.getLocation().add(0.0, this.height, 0.0)), (long)(i * 5));
                }
            }
        }
        catch (ParticleEffect.ParticlePacket.VersionIncompatibleException | ParticleEffect.ParticleVersionException e) {
            if (playerConfig.isScheduled()) {
                Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
            }
            e.printStackTrace();
        }
    }

    private static class DragonsBreathRunnable
    extends DisplayRegularRunnable
    implements Runnable {
        Particle enumParticle;

        public DragonsBreathRunnable(ParticleEffect particle, float xOff, float yOff, float zOff, float speed, Location loc) {
            super(particle, xOff, yOff, zOff, speed, loc);
            this.enumParticle = Particle.valueOf((String)particle.name());
        }

        @Override
        public void run() {
            this.loc.getWorld().spawnParticle(this.enumParticle, this.loc, 1, (double)this.xOff, (double)this.yOff, (double)this.zOff, (double)this.speed);
        }
    }

    private static class DisplayRegularRunnable
    implements Runnable {
        final ParticleEffect particle;
        final float xOff;
        final float yOff;
        final float zOff;
        final float speed;
        final Location loc;

        @Override
        public void run() {
            this.particle.display(this.xOff, this.yOff, this.zOff, this.speed, 1, this.loc, 64.0);
        }

        @ConstructorProperties(value={"particle", "xOff", "yOff", "zOff", "speed", "loc"})
        public DisplayRegularRunnable(ParticleEffect particle, float xOff, float yOff, float zOff, float speed, Location loc) {
            this.particle = particle;
            this.xOff = xOff;
            this.yOff = yOff;
            this.zOff = zOff;
            this.speed = speed;
            this.loc = loc;
        }
    }

    private static class DisplayColourableRunnable
    implements Runnable {
        final ParticleEffect particle;
        final ParticleEffect.ParticleColor data;
        final Location loc;

        @Override
        public void run() {
            this.particle.display(this.data, this.loc, 32.0);
        }

        @ConstructorProperties(value={"particle", "data", "loc"})
        public DisplayColourableRunnable(ParticleEffect particle, ParticleEffect.ParticleColor data, Location loc) {
            this.particle = particle;
            this.data = data;
            this.loc = loc;
        }
    }
}

