/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.runnables;

import de.myzelyam.api.vanish.VanishAPI;
import java.sql.SQLException;
import java.util.UUID;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.runnables.MySQLRunnable;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.storage.ParticleData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LoadRunnable
extends MySQLRunnable {
    private final Player player;

    public LoadRunnable(UUID uuid) {
        super(uuid);
        this.player = Bukkit.getPlayer((UUID)uuid);
    }

    @Override
    public void run() {
        ParticleData particleData;
        try {
            particleData = (ParticleData)instance.getParticleStorage().queryForId(this.uuidBytes);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        if (particleData == null) {
            return;
        }
        ParticleEffect particleEff = null;
        for (ParticleEffect pEff : ParticleEffect.values()) {
            if (!pEff.toString().equals(particleData.getParticle())) continue;
            if (pEff.equals((Object)ParticleEffect.FOOTSTEP)) {
                return;
            }
            particleEff = pEff;
            break;
        }
        PlayerConfig playerConfig = new PlayerConfig(this.uuid, particleEff, particleData.getType(), particleData.getLength(), particleData.getHeight(), particleData.getColour());
        TrailManager.addPlayerConfig(this.uuid, playerConfig);
        if (TrailManager.hasVanishHook()) {
            TrailManager.VanishHook vanishHook = TrailManager.getVanishHook();
            boolean shouldBeVanished = false;
            switch (vanishHook) {
                case VANISH_NO_PACKET: {
                    shouldBeVanished = this.player.hasPermission("vanish.silentjoin");
                    break;
                }
                case SUPER_PREMIUM_VANISH: {
                    shouldBeVanished = VanishAPI.isInvisible((Player)this.player);
                }
            }
            if (shouldBeVanished) {
                playerConfig.setVanished(true);
                if (playerConfig.isScheduled()) {
                    Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
                    playerConfig.resetTaskId();
                }
            }
        }
    }
}

