/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.listeners;

import java.util.UUID;
import net.auscraft.BlivTrails.BlivTrails;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.config.TrailDefaults;
import net.auscraft.BlivTrails.runnables.TrailRunnable;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class TrailListener
implements Listener {
    private boolean displayWhenSpinning = false;
    private long joinActivationDelay = 100L;

    public TrailListener() {
        FlatFile cfg = FlatFile.getInstance();
        this.displayWhenSpinning = cfg.getSave().getBoolean("trails.misc.display-when-spinning", false);
        this.joinActivationDelay = (long)cfg.getSave().getInt("trails.misc.join-activation-delay", 5) * 20L;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (this.joinActivationDelay > 0L) {
            Bukkit.getScheduler().runTaskLater((Plugin)BlivTrails.getInstance(), new Runnable(){

                @Override
                public void run() {
                    TrailManager.loadTrail(player);
                }
            }, this.joinActivationDelay);
        } else {
            TrailManager.loadTrail(player);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
        if (playerConfig != null) {
            TrailManager.saveTrail((OfflinePlayer)player);
            if (playerConfig.isScheduled()) {
                Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
            }
            TrailManager.removePlayer(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.displayWhenSpinning && event.getFrom().getX() == event.getTo().getX() && event.getFrom().getY() == event.getTo().getY() && event.getFrom().getZ() == event.getTo().getZ()) {
            return;
        }
        UUID uuid = event.getPlayer().getUniqueId();
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(uuid);
        if (playerConfig == null) {
            return;
        }
        if (TrailManager.hasVanishHook() && playerConfig.isVanished()) {
            return;
        }
        playerConfig.setTrailTime(TrailManager.getTrailLength());
        if (playerConfig.isScheduled()) {
            return;
        }
        if (!playerConfig.hasValidParticle()) {
            TrailManager.removePlayer(playerConfig);
            return;
        }
        int speed = 1;
        TrailDefaults.ParticleDefaultStorage particleDefaults = TrailDefaults.getDefaults(playerConfig.getParticle());
        if (particleDefaults.getDisplaySpeed() > 0) {
            speed = particleDefaults.getDisplaySpeed();
        }
        TrailRunnable trailRunnable = new TrailRunnable(event.getPlayer(), playerConfig, TrailManager.getOption());
        try {
            trailRunnable.run();
        }
        catch (Exception e) {
            BUtil.logError("An error occurred while displaying " + event.getPlayer().getName() + "'s trail. It will be disabled.");
            e.printStackTrace();
            TrailManager.removePlayer(uuid);
            return;
        }
        playerConfig.setTaskId(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)BlivTrails.getInstance(), (Runnable)trailRunnable, 1L, (long)speed).getTaskId());
    }
}

