/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.auscraft.BlivTrails.OptionType;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.config.Messages;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.util.BUtil;
import net.auscraft.BlivTrails.util.GUIUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIListener
implements Listener {
    private static FlatFile cfg = null;
    private static Messages msg = null;
    private static ItemStack BACK_BUTTON = null;
    private static final String[] colourCfgName = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "light-grey", "grey", "pink", "lime", "yellow", "light-blue", "magenta", "orange", "white", "random"};
    private static final String[] colourNames = new String[]{"\u00a70Black", "\u00a7cRed", "\u00a72Green", "\u00a76Brown", "\u00a79Blue", "\u00a75Purple", "\u00a73Cyan", "\u00a77Light Grey", "\u00a78Grey", "\u00a7dPink", "\u00a7Lime", "\u00a7eYellow", "\u00a7bLight Blue", "\u00a7dMagenta", "\u00a76Orange", "\u00a7fWhite", "\u00a76Random"};
    private static final ItemStack INVALID_ITEM = GUIUtil.createItem(Material.POTATO_ITEM, 0, 32, "\u00a7cVersion does not support this Material!", null, null);

    public static void reload() {
        if (cfg == null) {
            cfg = FlatFile.getInstance();
        } else {
            cfg.reloadFile();
        }
        if (msg == null) {
            msg = Messages.getInstance();
        } else {
            msg.reloadFile();
        }
        BACK_BUTTON = GUIUtil.createItem(GUIListener.getVersionSafeMaterial(cfg.getString("menu.options.back-button.material")), 0, 1, msg.getString("messages.options.titles.back"), null, cfg.getStringList("menu.options.back-button.lore"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() == null || event.getInventory().getTitle() == null || event.getRawSlot() < 0 || event.getRawSlot() >= 54) {
            return;
        }
        if (event.getInventory().getTitle().equals(msg.getString("messages.titles.main-menu"))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= cfg.getInt("menu.main.size")) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == cfg.getInt("trails.remove-trail.position")) {
                if (playerConfig != null) {
                    TrailManager.removePlayer(player.getUniqueId());
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.generic.trail-removed"));
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.error.no-trail-remove"));
                }
                if (cfg.getBoolean("menu.main.minimise-on-select")) {
                    player.closeInventory();
                }
            } else if (event.getRawSlot() == cfg.getInt("trails.options-menu.position")) {
                if (player.hasPermission("blivtrails.options")) {
                    if (playerConfig == null || playerConfig.getParticle() == null || playerConfig.getParticle() == ParticleEffect.FOOTSTEP) {
                        BUtil.printPlain((CommandSender)event.getWhoClicked(), msg.getString("messages.error.no-trail"));
                        return;
                    }
                    if (!GUIListener.optionsMenu(player)) {
                        BUtil.printPlain((CommandSender)event.getWhoClicked(), msg.getString("messages.error.no-trail"));
                    }
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.options.base"));
                }
            } else {
                for (ParticleEffect particleEff : TrailManager.usedTrails) {
                    String particleString = BUtil.trailConfigName(particleEff.toString());
                    if (!event.getCurrentItem().getType().equals((Object)Material.getMaterial((String)cfg.getString("trails." + particleString + ".material")))) continue;
                    if (!particleEff.isSupported()) {
                        player.sendMessage("\u00a7cThis trail is not supported by your server version.");
                        return;
                    }
                    if (player.hasPermission("blivtrails." + particleString)) {
                        if (playerConfig != null && playerConfig.isScheduled()) {
                            Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
                            playerConfig.resetTaskId();
                            playerConfig.setParticle(ParticleEffect.FOOTSTEP);
                        }
                        TrailManager.doDefaultTrail(player.getUniqueId(), particleEff);
                        if (cfg.getBoolean("menu.main.minimise-on-select")) {
                            player.closeInventory();
                        }
                    } else {
                        BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.trail"));
                    }
                    break;
                }
            }
        } else if (event.getInventory().getTitle().equals(msg.getString("messages.titles.main-options"))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= 18) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == cfg.getInt("menu.options.config.type.position")) {
                if (player.hasPermission("blivtrails.options.type")) {
                    GUIListener.optionsMenuType(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.type.base"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.config.length.position")) {
                if (player.hasPermission("blivtrails.options.length")) {
                    GUIListener.optionsMenuLength(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.length.base"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.config.height.position")) {
                if (player.hasPermission("blivtrails.options.height")) {
                    GUIListener.optionsMenuHeight(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.height.base"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.config.colour.position")) {
                if (playerConfig.getParticle().hasProperty(ParticleEffect.ParticleProperty.COLORABLE) && !playerConfig.getParticle().equals((Object)ParticleEffect.FOOTSTEP)) {
                    if (player.hasPermission("blivtrails.options.colour")) {
                        GUIListener.optionsMenuColour(player);
                    } else {
                        BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.length.base"));
                    }
                } else {
                    BUtil.printError((CommandSender)player, msg.getString("messages.error.option-trail-no-support"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.back-button.position")) {
                GUIListener.mainMenu(player);
            }
        } else if (event.getInventory().getTitle().equals(msg.getString("messages.titles.type"))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= 18) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == 3) {
                if (player.hasPermission("blivtrails.options.type.trace")) {
                    pcfg.setType(OptionType.TYPE_TRACE);
                    GUIListener.optionsMenuType(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.type.trace"));
                }
            }
            if (event.getRawSlot() == 4) {
                if (player.hasPermission("blivtrails.options.type.random")) {
                    pcfg.setType(OptionType.TYPE_RANDOM);
                    GUIListener.optionsMenuType(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.type.random"));
                }
            }
            if (event.getRawSlot() == 5) {
                if (pcfg.getParticle().hasProperty(ParticleEffect.ParticleProperty.COLORABLE) || !pcfg.getParticle().hasProperty(ParticleEffect.ParticleProperty.DIRECTIONAL)) {
                    BUtil.printError((CommandSender)player, msg.getString("messages.error.option-trail-no-support"));
                    return;
                }
                if (player.hasPermission("blivtrails.options.type.dynamic")) {
                    pcfg.setType(OptionType.TYPE_DYNAMIC);
                    GUIListener.optionsMenuType(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.type.dynamic"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.back-button.position")) {
                GUIListener.optionsMenu(player);
            }
        } else if (event.getInventory().getTitle().equals(msg.getString("messages.titles.length"))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= 18) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == 3) {
                if (player.hasPermission("blivtrails.options.length.short")) {
                    pcfg.setLength(OptionType.LENGTH_SHORT);
                    GUIListener.optionsMenuLength(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.length.short"));
                }
            } else if (event.getRawSlot() == 4) {
                if (player.hasPermission("blivtrails.options.length.medium")) {
                    pcfg.setLength(OptionType.LENGTH_MEDIUM);
                    GUIListener.optionsMenuLength(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.length.medium"));
                }
            } else if (event.getRawSlot() == 5) {
                if (player.hasPermission("blivtrails.options.length.long")) {
                    pcfg.setLength(OptionType.LENGTH_LONG);
                    GUIListener.optionsMenuLength(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.length.long"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.back-button.position")) {
                GUIListener.optionsMenu(player);
            }
        } else if (event.getInventory().getTitle().equals(msg.getString("messages.titles.height"))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= 18) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == 3) {
                if (player.hasPermission("blivtrails.options.height.feet")) {
                    pcfg.setHeight(OptionType.HEIGHT_FEET);
                    GUIListener.optionsMenuHeight(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.height.feet"));
                }
            }
            if (event.getRawSlot() == 4) {
                if (player.hasPermission("blivtrails.options.height.waist")) {
                    pcfg.setHeight(OptionType.HEIGHT_WAIST);
                    GUIListener.optionsMenuHeight(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.height.waist"));
                }
            }
            if (event.getRawSlot() == 5) {
                if (player.hasPermission("blivtrails.options.height.halo")) {
                    pcfg.setHeight(OptionType.HEIGHT_HALO);
                    GUIListener.optionsMenuHeight(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.height.halo"));
                }
            } else if (event.getRawSlot() == cfg.getInt("menu.options.back-button.position")) {
                GUIListener.optionsMenu(player);
            }
        } else if (BUtil.stripColours(event.getInventory().getTitle()).contains(BUtil.stripColours(msg.getString("messages.titles.colours")))) {
            event.setCancelled(true);
            if (event.getRawSlot() >= 18) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
            if (event.getRawSlot() == cfg.getInt("menu.options.back-button.position")) {
                GUIListener.optionsMenu(player);
            } else if (event.getCurrentItem().getType().equals((Object)Material.INK_SACK)) {
                if (pcfg.getParticle() == ParticleEffect.NOTE) {
                    switch (event.getCurrentItem().getDurability()) {
                        case 0: 
                        case 3: 
                        case 7: 
                        case 8: 
                        case 15: {
                            BUtil.printError((CommandSender)player, msg.getString("messages.error.option-trail-no-support"));
                            return;
                        }
                    }
                }
                if (player.hasPermission("blivtrails.options.colour." + BUtil.intToColour(event.getCurrentItem().getDurability()))) {
                    pcfg.setColour(event.getCurrentItem().getDurability());
                    GUIListener.optionsMenuColour(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.colour.colour"));
                }
            } else if (event.getCurrentItem().getType().equals((Object)Material.POTION)) {
                if (player.hasPermission("blivtrails.options.colour.random")) {
                    pcfg.setColour(16);
                    GUIListener.optionsMenuColour(player);
                } else {
                    BUtil.printPlain((CommandSender)player, msg.getString("messages.no-permission.colour.random"));
                }
            } else {
                BUtil.printPlain((CommandSender)player, msg.getString("messages.error.no-exist"));
            }
        }
    }

    public static void mainMenu(Player player) {
        PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
        if (pcfg == null) {
            pcfg = new PlayerConfig(player.getUniqueId());
        }
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.main.size"), (String)msg.getString("messages.titles.main-menu"));
        if (cfg.getBoolean("trails.remove-trail.display")) {
            GUIListener.setInventoryItem(inventory, cfg.getInt("trails.remove-trail.position"), GUIListener.menuItem(cfg.getString("trails.remove-trail.material"), BUtil.translateColours(cfg.getString("trails.remove-trail.name")), BUtil.translateColours(cfg.getStringList("trails.remove-trail.lore")), player.hasPermission("blivtrails.remove-trail"), false));
        }
        for (ParticleEffect particleEff : TrailManager.usedTrails) {
            String particleString = BUtil.trailConfigName(particleEff.toString());
            if (!cfg.getBoolean("trails." + particleString + ".display")) continue;
            GUIListener.setInventoryItem(inventory, cfg.getInt("trails." + particleString + ".position"), GUIListener.menuItem(cfg.getString("trails." + particleString + ".material"), BUtil.translateColours(cfg.getString("trails." + particleString + ".name")), BUtil.translateColours(cfg.getStringList("trails." + particleString + ".lore")), player.hasPermission("blivtrails." + particleString), pcfg.getParticle() == particleEff));
        }
        if (cfg.getBoolean("trails.options-menu.display")) {
            GUIListener.setInventoryItem(inventory, cfg.getInt("trails.options-menu.position"), GUIListener.menuItem(cfg.getString("trails.options-menu.material"), BUtil.translateColours(cfg.getString("trails.options-menu.name")), BUtil.translateColours(cfg.getStringList("trails.options-menu.lore")), player.hasPermission("blivtrails.options"), false));
        }
        GUIListener.addCustomInventoryItems(inventory, "MAIN");
        player.openInventory(inventory);
    }

    public static boolean optionsMenu(Player player) {
        PlayerConfig pcfg = TrailManager.getPlayerConfig(player.getUniqueId());
        if (pcfg == null) {
            return false;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.options.size"), (String)msg.getString("messages.titles.main-options"));
        GUIListener.addMenuOptionItemIfEnabled(inventory, cfg.getInt("menu.options.config." + OptionType.TYPE.getConfigName() + ".position"), player, OptionType.TYPE, Material.GLASS_BOTTLE);
        GUIListener.addMenuOptionItemIfEnabled(inventory, cfg.getInt("menu.options.config." + OptionType.LENGTH.getConfigName() + ".position"), player, OptionType.LENGTH, Material.ARROW);
        GUIListener.addMenuOptionItemIfEnabled(inventory, cfg.getInt("menu.options.config." + OptionType.HEIGHT.getConfigName() + ".position"), player, OptionType.HEIGHT, Material.FENCE);
        if (cfg.getBoolean("menu.options.config.colour.enabled")) {
            GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.config.colour.position"), GUIListener.optionsColour(player, pcfg.getParticle()));
        }
        GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.back-button.position"), BACK_BUTTON);
        GUIListener.addCustomInventoryItems(inventory, "OPTIONS");
        player.openInventory(inventory);
        return true;
    }

    private static void addCustomInventoryItems(Inventory inventory, String menuId) {
        ConfigurationSection extraItemSection = cfg.getSave().getConfigurationSection("menu.extras");
        if (extraItemSection != null) {
            for (String extra : extraItemSection.getKeys(false)) {
                if (!extraItemSection.getString(extra + ".menu").equals(menuId)) continue;
                GUIListener.setInventoryItem(inventory, extraItemSection.getInt(extra + ".position"), GUIUtil.createItem(GUIListener.getVersionSafeMaterial(extraItemSection.getString(extra + ".material")), extraItemSection.getInt(extra + ".damage"), 1, extraItemSection.getString(extra + ".title"), null, extraItemSection.getStringList(extra + ".lore")));
            }
        }
    }

    private static boolean addMenuOptionItemIfEnabled(Inventory inventory, int slot, Player player, OptionType optionType, Material material) {
        if (cfg.getBoolean("menu.options.config." + optionType.getConfigName() + ".enabled")) {
            return GUIListener.setInventoryItem(inventory, slot, GUIListener.optionMenuItem(player, material, optionType));
        }
        return false;
    }

    private static boolean addOptionItemIfEnabled(Inventory inventory, int slot, Player player, OptionType optionType, PlayerConfig playerConfig) {
        if (cfg.getBoolean("menu.options.config." + optionType.getConfigName())) {
            return GUIListener.setInventoryItem(inventory, slot, GUIListener.optionItem(player, optionType, optionType.isOptionActive(playerConfig.getEnabledOption(optionType)), playerConfig.getParticle()));
        }
        return false;
    }

    public static void optionsMenuType(Player player) {
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.options.size"), (String)msg.getString("messages.titles.type"));
        GUIListener.addOptionItemIfEnabled(inventory, 3, player, OptionType.TYPE_TRACE, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 4, player, OptionType.TYPE_RANDOM, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 5, player, OptionType.TYPE_DYNAMIC, playerConfig);
        GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.back-button.position"), BACK_BUTTON);
        GUIListener.addCustomInventoryItems(inventory, "TYPE");
        player.openInventory(inventory);
    }

    public static void optionsMenuLength(Player player) {
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.options.size"), (String)msg.getString("messages.titles.length"));
        GUIListener.addOptionItemIfEnabled(inventory, 3, player, OptionType.LENGTH_SHORT, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 4, player, OptionType.LENGTH_MEDIUM, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 5, player, OptionType.LENGTH_LONG, playerConfig);
        GUIListener.setInventoryItem(inventory, 13, GUIListener.informationItem(msg.getStringList("messages.information.length.info")));
        GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.back-button.position"), BACK_BUTTON);
        GUIListener.addCustomInventoryItems(inventory, "LENGTH");
        player.openInventory(inventory);
    }

    public static void optionsMenuHeight(Player player) {
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.options.size"), (String)msg.getString("messages.titles.height"));
        GUIListener.addOptionItemIfEnabled(inventory, 3, player, OptionType.HEIGHT_FEET, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 4, player, OptionType.HEIGHT_WAIST, playerConfig);
        GUIListener.addOptionItemIfEnabled(inventory, 5, player, OptionType.HEIGHT_HALO, playerConfig);
        GUIListener.setInventoryItem(inventory, 13, GUIListener.informationItem(msg.getStringList("messages.information.height.info")));
        GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.back-button.position"), BACK_BUTTON);
        GUIListener.addCustomInventoryItems(inventory, "HEIGHT");
        player.openInventory(inventory);
    }

    public static void optionsMenuColour(Player player) {
        PlayerConfig playerConfig = TrailManager.getPlayerConfig(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)cfg.getInt("menu.options.config.colour.size"), (String)msg.getString("messages.titles.colours"));
        ConfigurationSection colourPositionSection = cfg.getConfigurationSection("menu.options.config.colour");
        if (colourPositionSection == null) {
            BUtil.logError("The colour position configuration section has been removed at 'menu.options.config.colour', but it is still enabled. Are you sure you know what you're doing?");
            return;
        }
        for (int colourId = 0; colourId < colourCfgName.length; ++colourId) {
            if (cfg.getInt("menu.options.config.colour." + colourCfgName[colourId]) == -1) continue;
            GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.config.colour." + colourCfgName[colourId]), GUIListener.optionsColourItem(player, playerConfig.getColour() == colourId, colourId, playerConfig.getParticle()));
        }
        GUIListener.setInventoryItem(inventory, cfg.getInt("menu.options.config.colour.back-button-pos"), BACK_BUTTON);
        GUIListener.addCustomInventoryItems(inventory, "COLOUR");
        player.openInventory(inventory);
    }

    private static boolean setInventoryItem(Inventory inventory, int slot, ItemStack itemStack) {
        if (inventory == null || itemStack == null) {
            return false;
        }
        if (slot < 0 || slot >= inventory.getSize()) {
            if (slot != -1) {
                BUtil.logError("Attempted to place " + itemStack.getType() + " - " + itemStack.getItemMeta().getDisplayName() + " outside of inventory " + inventory.getType() + ".");
            }
            return false;
        }
        inventory.setItem(slot, itemStack);
        return true;
    }

    public static ItemStack optionMenuItem(Player player, Material material, OptionType optionType) {
        ItemStack itemStack = GUIUtil.createItem(material, 0, 1, msg.getString("messages.options.titles.categories." + optionType.getConfigName()), null, null);
        if (!player.hasPermission("blivtrails.options." + optionType.getConfigName())) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setLore(Collections.singletonList(BUtil.translateColours(cfg.getString("messages.indicators.dont-have-permission"))));
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static ItemStack optionItem(Player player, OptionType optionType, boolean isEnabled, ParticleEffect particleEffect) {
        ItemStack itemStack = GUIUtil.createItem(Material.INK_SACK, 8, 1, msg.getString("messages.options.titles." + optionType.getConfigName()), null, null);
        if (isEnabled) {
            itemStack.setDurability((short)10);
            ItemMeta itemMeta = itemStack.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            if (!player.hasPermission("blivtrails.options." + optionType.getConfigName())) {
                lore.add(msg.getString("messages.indicators.dont-have-permission"));
            } else {
                lore.add(msg.getString("messages.generic.enabled-lore"));
            }
            if (optionType == OptionType.TYPE_DYNAMIC) {
                if (particleEffect.hasProperty(ParticleEffect.ParticleProperty.DIRECTIONAL)) {
                    lore.add(msg.getString("messages.options.supports-dynamic"));
                } else {
                    lore.add(msg.getString("messages.options.doesnt-support-dynamic"));
                }
            }
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static ItemStack optionsColour(Player player, ParticleEffect particle) {
        ItemStack itemStack = GUIUtil.createItem(Material.INK_SACK, 14, 1, msg.getString("messages.options.titles.categories.colour"), null, null);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (!player.hasPermission("blivtrails.options.colour")) {
            lore.add(BUtil.translateColours("messages.indicators.dont-have-permission"));
        } else if (particle.hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
            lore.add(msg.getString("messages.options.supports-colours"));
        } else {
            lore.add(msg.getString("messages.options.doesnt-support-colours"));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack optionsColourItem(Player player, boolean isEnabled, int colourId, ParticleEffect particle) {
        ItemStack item = new ItemStack(Material.INK_SACK, 1, (short)colourId);
        if (colourId == colourNames.length - 1) {
            item = new ItemStack(Material.POTION, 1);
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(colourNames[colourId]);
        ArrayList<String> lore = new ArrayList<String>();
        if (!player.hasPermission("blivtrails.options.colour." + colourCfgName[colourId])) {
            lore.add(msg.getString("messages.indicators.dont-have-permission"));
        } else if (isEnabled) {
            lore.add(msg.getString("messages.generic.enabled-lore"));
        }
        if (particle == ParticleEffect.NOTE) {
            String isDisabled = null;
            switch (colourId) {
                case 0: 
                case 3: 
                case 7: 
                case 8: 
                case 15: {
                    isDisabled = msg.getString("messages.options.doesnt-apply-to-note");
                    break;
                }
            }
            if (isDisabled != null) {
                lore.add(isDisabled);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack informationItem(List<String> list) {
        return GUIUtil.createItem(Material.BOOK, 0, 1, msg.getString("messages.options.titles.information"), null, list);
    }

    public static ItemStack menuItem(String material, String name, List<String> lore, boolean hasPermission, boolean isSelected) {
        List lorePerm;
        ItemStack item = GUIListener.getVersionSafeItemStack(material);
        if (item == INVALID_ITEM) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        if (hasPermission) {
            if (meta.getLore() == null) {
                meta.setLore(Collections.singletonList(msg.getString("messages.indicators.have-permission")));
            } else {
                lorePerm = meta.getLore();
                lorePerm.add(msg.getString("messages.indicators.have-permission"));
                meta.setLore(lorePerm);
            }
        } else if (meta.getLore() == null) {
            meta.setLore(Collections.singletonList(msg.getString("messages.indicators.dont-have-permission")));
        } else {
            lorePerm = meta.getLore();
            lorePerm.add(msg.getString("messages.indicators.dont-have-permission"));
            meta.setLore(lorePerm);
        }
        if (isSelected) {
            if (meta.getLore() == null) {
                meta.setLore(Collections.singletonList(msg.getString("messages.indicators.trail-selected")));
            } else {
                lorePerm = meta.getLore();
                lorePerm.add(msg.getString("messages.indicators.trail-selected"));
                meta.setLore(lorePerm);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack getVersionSafeItemStack(String materialName) {
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            BUtil.logError("Attempted to use material: '" + materialName + "', which is INVALID at your current version: " + Bukkit.getBukkitVersion() + " reverting to POTATO_ITEM");
            return INVALID_ITEM;
        }
        return new ItemStack(material, 1);
    }

    public static Material getVersionSafeMaterial(String materialName) {
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            BUtil.logError("Attempted to use material: '" + materialName + "', which is INVALID at your current version: " + Bukkit.getBukkitVersion() + " reverting to POTATO_ITEM");
            return Material.POTATO_ITEM;
        }
        return material;
    }
}

