/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.config;

import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentHashMap;
import net.auscraft.BlivTrails.OptionType;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.configuration.ConfigurationSection;

public class TrailDefaults {
    private static TrailDefaults instance = null;
    private static ConcurrentHashMap<ParticleEffect, ParticleDefaultStorage> particleDefaults = new ConcurrentHashMap();
    private static ParticleDefaultStorage defaultParticleOptions = null;

    public static TrailDefaults getInstance() {
        if (instance == null) {
            instance = new TrailDefaults();
        }
        return instance;
    }

    private TrailDefaults() {
        FlatFile cfg = FlatFile.getInstance();
        defaultParticleOptions = new ParticleDefaultStorage("", OptionType.TYPE_TRACE, OptionType.LENGTH_SHORT, OptionType.HEIGHT_FEET, 0, 1, TrailManager.getOption()[0], TrailManager.getOption()[1], TrailManager.getOption()[2], TrailManager.getOption()[3], TrailManager.getOption()[4], TrailManager.getOption()[5], TrailManager.getOption()[6]);
        ConfigurationSection trailSection = cfg.getConfigurationSection("trails");
        for (ParticleEffect particle : TrailManager.usedTrails) {
            String particleString = BUtil.trailConfigName(particle.name());
            if (particleString.isEmpty()) continue;
            ConfigurationSection trailDefaultSection = trailSection.getConfigurationSection(particleString);
            int particleColour = 15;
            if (particle.hasProperty(ParticleEffect.ParticleProperty.COLORABLE)) {
                switch (particle) {
                    case DRAGON_BREATH: {
                        particleColour = 13;
                        break;
                    }
                    case REDSTONE: {
                        particleColour = 1;
                        break;
                    }
                    default: {
                        OptionType.parseColourString(trailDefaultSection.getString("options.colour"));
                    }
                }
            }
            particleDefaults.put(particle, new ParticleDefaultStorage(BUtil.translateColours(trailDefaultSection.getString("name")), OptionType.parseTypeString(trailDefaultSection.getString("options.type")), OptionType.parseLengthString(trailDefaultSection.getString("options.length")), OptionType.parseHeightString(trailDefaultSection.getString("options.height")), particleColour, trailDefaultSection.getInt("options.display-speed"), trailDefaultSection.getInt("options.defaults.random.x-variation"), trailDefaultSection.getInt("options.defaults.random.y-variation"), trailDefaultSection.getInt("options.defaults.random.z-variation"), trailDefaultSection.getInt("options.defaults.dynamic.spray-variation"), trailDefaultSection.getInt("options.defaults.height.feet-location"), trailDefaultSection.getInt("options.defaults.height.waist-location"), trailDefaultSection.getInt("options.defaults.height.halo-location")));
        }
    }

    public static ParticleDefaultStorage getDefaults(ParticleEffect particle) {
        ParticleDefaultStorage particleDefaultOptions = particleDefaults.get((Object)particle);
        if (particleDefaultOptions == null) {
            return defaultParticleOptions;
        }
        return particleDefaultOptions;
    }

    public static ConcurrentHashMap<ParticleEffect, ParticleDefaultStorage> getParticleDefaults() {
        return particleDefaults;
    }

    public static class ParticleDefaultStorage {
        private String displayName;
        private OptionType type;
        private OptionType length;
        private OptionType height;
        private int colour;
        private int displaySpeed;
        private double xVariation;
        private double yVariation;
        private double zVariation;
        private double sprayVariation;
        private double feetLocation;
        private double waistLocation;
        private double haloLocation;

        @ConstructorProperties(value={"displayName", "type", "length", "height", "colour", "displaySpeed", "xVariation", "yVariation", "zVariation", "sprayVariation", "feetLocation", "waistLocation", "haloLocation"})
        public ParticleDefaultStorage(String displayName, OptionType type, OptionType length, OptionType height, int colour, int displaySpeed, double xVariation, double yVariation, double zVariation, double sprayVariation, double feetLocation, double waistLocation, double haloLocation) {
            this.displayName = displayName;
            this.type = type;
            this.length = length;
            this.height = height;
            this.colour = colour;
            this.displaySpeed = displaySpeed;
            this.xVariation = xVariation;
            this.yVariation = yVariation;
            this.zVariation = zVariation;
            this.sprayVariation = sprayVariation;
            this.feetLocation = feetLocation;
            this.waistLocation = waistLocation;
            this.haloLocation = haloLocation;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public OptionType getType() {
            return this.type;
        }

        public OptionType getLength() {
            return this.length;
        }

        public OptionType getHeight() {
            return this.height;
        }

        public int getColour() {
            return this.colour;
        }

        public int getDisplaySpeed() {
            return this.displaySpeed;
        }

        public double getXVariation() {
            return this.xVariation;
        }

        public double getYVariation() {
            return this.yVariation;
        }

        public double getZVariation() {
            return this.zVariation;
        }

        public double getSprayVariation() {
            return this.sprayVariation;
        }

        public double getFeetLocation() {
            return this.feetLocation;
        }

        public double getWaistLocation() {
            return this.waistLocation;
        }

        public double getHaloLocation() {
            return this.haloLocation;
        }
    }
}

