/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.auscraft.BlivTrails.BlivTrails;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FlatFile {
    protected File saveFile = null;
    protected FileConfiguration save = null;
    static volatile FlatFile instance = null;
    static JavaPlugin plugin = null;
    String fileName = "config.yml";
    public static final Location DEFAULT_LOCATION = new Location((World)Bukkit.getWorlds().get(0), 0.0, 128.0, 0.0);

    public static FlatFile getInstance() {
        if (instance == null) {
            instance = new FlatFile();
        }
        return instance;
    }

    FlatFile() {
        this("config.yml");
    }

    FlatFile(String fileName) {
        this.fileName = fileName;
        plugin = BlivTrails.getInstance();
        this.saveDefaultConfig();
        this.getSave();
    }

    public FileConfiguration getSave() {
        if (this.save == null) {
            this.reloadFile();
        }
        return this.save;
    }

    public boolean reloadFile() {
        if (this.saveFile == null) {
            this.saveFile = new File(plugin.getDataFolder(), this.fileName);
        }
        this.save = YamlConfiguration.loadConfiguration((File)this.saveFile);
        InputStreamReader defConfigStream = null;
        try {
            defConfigStream = new InputStreamReader(plugin.getResource(this.fileName), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        boolean invalid = false;
        if (this.getBoolean("misc.config-checking")) {
            BUtil.logInfo("Checking Config...");
            invalid = this.checkConfig();
            BUtil.logInfo("Config Checked!");
        }
        return invalid;
    }

    public void saveDefaultConfig() {
        if (this.saveFile == null) {
            this.saveFile = new File(plugin.getDataFolder(), this.fileName);
        }
        if (!this.saveFile.exists()) {
            plugin.saveResource(this.fileName, false);
        }
    }

    public void saveToFile() {
        if (this.save == null || this.saveFile == null) {
            return;
        }
        try {
            this.save.save(this.saveFile);
        }
        catch (IOException ex) {
            BUtil.logError("Could not save config to " + this.saveFile);
        }
    }

    public void removeEntry(String path) {
        this.save.set(path, null);
    }

    public void saveEntry(String path, String entry) {
        this.save.set(path, (Object)entry);
        this.saveToFile();
    }

    public String loadEntry(String path) {
        return this.save.getString(path);
    }

    public Set<String> getChildren(String path) {
        return this.save.getConfigurationSection(path).getKeys(false);
    }

    public String getString(String path) {
        return this.getString(path, "");
    }

    public String getString(String path, String defaultString) {
        return this.save.getString(path, defaultString);
    }

    public List<String> getStringList(String path) {
        return this.save.getStringList(path);
    }

    public int getInt(String path) {
        return this.save.getInt(path);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean defaultBoolean) {
        return this.save.getBoolean(path, defaultBoolean);
    }

    public long getLong(String path) {
        return this.save.getLong(path);
    }

    public void saveValue(String path, Object value) {
        this.save.set(path, value);
        this.saveToFile();
    }

    public double getDouble(String path) {
        return this.save.getDouble(path);
    }

    public float getFloat(String path) {
        return (float)this.save.getDouble(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.save.getConfigurationSection(path);
    }

    public static Location parseLocation(String locationString) {
        String[] locationSplit = locationString.split("[:]");
        try {
            double x = Double.parseDouble(locationSplit[0]);
            double y = Double.parseDouble(locationSplit[1]);
            double z = Double.parseDouble(locationSplit[2]);
            float yaw = 0.0f;
            float pitch = 90.0f;
            if (locationSplit.length > 3) {
                yaw = Float.parseFloat(locationSplit[3]);
                pitch = Float.parseFloat(locationSplit[4]);
            }
            return new Location((World)Bukkit.getWorlds().get(0), x, y, z, yaw, pitch);
        }
        catch (NumberFormatException e) {
            BUtil.logError("Invalid location given by '" + locationString + "'. Returning default location.");
            return DEFAULT_LOCATION;
        }
    }

    public Location getLocation(String path) {
        return FlatFile.parseLocation(this.save.getString(path));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Location getLocation(ConfigurationSection configurationSection) {
        World world;
        block4: {
            if (configurationSection == null || configurationSection.getKeys(false).isEmpty()) {
                BUtil.logInfo("Configuration Section: " + (configurationSection == null ? "NULL" : configurationSection.getCurrentPath()) + " is NULL or empty!");
                return DEFAULT_LOCATION;
            }
            if (configurationSection.contains("world")) {
                String worldName = configurationSection.getString("world", null);
                if (worldName != null && Bukkit.getWorld((String)worldName) != null) {
                    world = Bukkit.getWorld((String)worldName);
                    break block4;
                } else {
                    BUtil.logError("World name '" + worldName + "' does not correspond to a valid world on this server. (" + configurationSection.getCurrentPath() + ")");
                    return DEFAULT_LOCATION;
                }
            }
            world = (World)Bukkit.getWorlds().get(0);
            BUtil.logError("No world defined in '" + configurationSection.getCurrentPath() + "'. Defaulting to " + world.getName() + ". Please define a world next time.");
        }
        double x = configurationSection.getDouble("x", 0.0);
        double y = configurationSection.getDouble("y", 128.0);
        double z = configurationSection.getDouble("z", 0.0);
        float pitch = (float)configurationSection.getDouble("pitch", 0.0);
        float yaw = (float)configurationSection.getDouble("yaw", 0.0);
        return new Location(world, x, y, z, yaw, pitch);
    }

    public List<Map<String, Object>> getListMap(String path) {
        return (List)this.save.get(path);
    }

    public static String getString(Map<String, Object> configurationMap, String path, String def) {
        Object object = configurationMap.get(path);
        if (object != null && object instanceof String && !((String)object).isEmpty()) {
            return (String)object;
        }
        return def;
    }

    public static List<String> getStringList(Map<String, Object> configurationMap, String path) {
        Object object = configurationMap.get(path);
        if (object != null && object instanceof List && !((List)object).isEmpty()) {
            return (List)object;
        }
        return new ArrayList<String>();
    }

    public static int getInt(Map<String, Object> configurationMap, String path, int def) {
        Object object = configurationMap.get(path);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return def;
    }

    public static Material getMaterial(Map<String, Object> configurationMap, String path, Material def) {
        Object object = configurationMap.get(path);
        if (object instanceof String) {
            Material toReturn = Material.getMaterial((String)((String)object));
            if (toReturn != null) {
                return toReturn;
            }
            BUtil.logError("Invalid material: " + object);
        }
        return def;
    }

    public boolean checkConfig() {
        boolean invalid = false;
        if (this.getInt("menu.main.size") % 9 != 0) {
            BUtil.logError("Your Main Menu GUI is not a multiple of 9, and cannot be displayed. (Size: " + this.getInt("menu.main.size") + ")");
            invalid = true;
        }
        if (this.getInt("menu.options.size") % 9 != 0) {
            BUtil.logError("Your Options Menu GUI is not a multiple of 9, and cannot be displayed. (Size: " + this.getInt("menu.options.size") + ")");
            invalid = true;
        }
        for (ParticleEffect pEff : ParticleEffect.values()) {
            String particleString = BUtil.trailConfigName(pEff.toString());
            if (particleString.isEmpty()) continue;
            if (this.getInt("trails." + particleString + ".position") >= this.getInt("menu.main.size") || this.getInt("trails." + particleString + ".position") < 0) {
                BUtil.logError("Trail " + particleString + "'s location is outside the menu bounds: " + this.getInt("trails." + particleString + ".position"));
                invalid = true;
            }
            try {
                Material.getMaterial((String)this.getString("trails." + particleString + ".material")).isBlock();
            }
            catch (NullPointerException e) {
                BUtil.logError("Trail " + particleString + " has an invalid material: " + this.getString("trails." + particleString + ".material"));
                invalid = true;
            }
        }
        this.checkGUIItem();
        BUtil.logInfo("Config Checking is enabled. If you encounter any freezes/stutters, turns this off once you've hit a stable config.");
        return invalid;
    }

    public void checkGUIItem() {
        boolean invalid = false;
        if (this.getInt("misc.gui-item.position") >= 36 || this.getInt("misc.gui-item.position") < 0) {
            BUtil.logError("The GUI Item's location is outside the inventory bounds: " + this.getString("misc.gui-item.position"));
            invalid = true;
        }
        try {
            Material.getMaterial((String)this.getString("misc.gui-item.material")).isBlock();
        }
        catch (NullPointerException e) {
            BUtil.logError("GUI Item has an invalid material: " + this.getString("misc.gui-item.material"));
            invalid = true;
        }
        if (!invalid && this.getBoolean("misc.enabled")) {
            ((BlivTrails)plugin).doItemListener();
        }
    }
}

