/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.auscraft.BlivTrails.BlivTrails;
import net.auscraft.BlivTrails.OptionType;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.config.FlatFileStorage;
import net.auscraft.BlivTrails.config.Messages;
import net.auscraft.BlivTrails.config.TrailDefaults;
import net.auscraft.BlivTrails.runnables.LoadRunnable;
import net.auscraft.BlivTrails.runnables.RemoveRunnable;
import net.auscraft.BlivTrails.runnables.SaveRunnable;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.shade.ormlite.jdbc.JdbcPooledConnectionSource;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.kitteh.vanish.VanishPlugin;

public class TrailManager {
    public static final ParticleEffect[] usedTrails = new ParticleEffect[]{ParticleEffect.VILLAGER_ANGRY, ParticleEffect.BARRIER, ParticleEffect.CLOUD, ParticleEffect.CRIT, ParticleEffect.CRIT_MAGIC, ParticleEffect.DRIP_LAVA, ParticleEffect.DRIP_WATER, ParticleEffect.ENCHANTMENT_TABLE, ParticleEffect.EXPLOSION_NORMAL, ParticleEffect.FIREWORKS_SPARK, ParticleEffect.FLAME, ParticleEffect.HEART, ParticleEffect.LAVA, ParticleEffect.NOTE, ParticleEffect.PORTAL, ParticleEffect.REDSTONE, ParticleEffect.SLIME, ParticleEffect.SMOKE_LARGE, ParticleEffect.SNOW_SHOVEL, ParticleEffect.SNOWBALL, ParticleEffect.SPELL, ParticleEffect.SPELL_INSTANT, ParticleEffect.SPELL_MOB, ParticleEffect.SPELL_WITCH, ParticleEffect.TOWN_AURA, ParticleEffect.VILLAGER_HAPPY, ParticleEffect.WATER_DROP, ParticleEffect.WATER_SPLASH, ParticleEffect.END_ROD, ParticleEffect.DRAGON_BREATH, ParticleEffect.DAMAGE_INDICATOR, ParticleEffect.SWEEP_ATTACK};
    private static ConcurrentHashMap<UUID, PlayerConfig> trailMap = new ConcurrentHashMap();
    private static FlatFileStorage flatFileStorage = null;
    private static Messages msg;
    private static double[] option;
    private static float trailLength;
    private static boolean useTrailNameColour;
    private static BukkitScheduler scheduler;
    private static VanishHook vanishHook;

    public static boolean usingSQL() {
        return flatFileStorage == null;
    }

    public static boolean hasVanishHook() {
        return vanishHook != VanishHook.NONE;
    }

    TrailManager() {
    }

    public static void init() {
        TrailManager.loadDefaultOptions();
        scheduler = Bukkit.getScheduler();
        FlatFile cfg = FlatFile.getInstance();
        msg = Messages.getInstance();
        trailLength = cfg.getFloat("trails.scheduler.trail-length");
        useTrailNameColour = FlatFile.getInstance().getBoolean("misc.trail-name-colour");
        Object saveLoc = BlivTrails.getSave();
        if (!(saveLoc instanceof JdbcPooledConnectionSource)) {
            flatFileStorage = (FlatFileStorage)saveLoc;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            TrailManager.loadTrail(player);
        }
    }

    public static void doDisable() {
        for (PlayerConfig playerConfig : trailMap.values()) {
            TrailManager.saveTrail(playerConfig);
        }
        if (!TrailManager.usingSQL()) {
            flatFileStorage.saveToFile();
        }
    }

    public static void loadDefaultOptions() {
        FlatFile cfg = FlatFile.getInstance();
        option = new double[7];
        for (OptionType optionType : EnumSet.of(OptionType.DEFAULT_X_VARIATION, new OptionType[]{OptionType.DEFAULT_Y_VARIATION, OptionType.DEFAULT_Z_VARIATION, OptionType.DEFAULT_SPRAY_VARIATION, OptionType.DEFAULT_FEET_LOCATION, OptionType.DEFAULT_WAIST_LOCATION, OptionType.DEFAULT_HALO_LOCATION})) {
            TrailManager.option[optionType.getCfgId()] = cfg.getDouble(optionType.getConfigName());
        }
        BUtil.logInfo("Finished Loading Defaults!");
    }

    public static void doDefaultTrail(UUID uuid, ParticleEffect particle) {
        TrailDefaults.ParticleDefaultStorage particleDefaults = TrailDefaults.getDefaults(particle);
        PlayerConfig playerConfig = trailMap.get(uuid);
        if (playerConfig == null) {
            playerConfig = new PlayerConfig(uuid, particle, particleDefaults.getType(), particleDefaults.getLength(), particleDefaults.getHeight(), particleDefaults.getColour());
            TrailManager.addPlayerConfig(uuid, playerConfig);
        }
        TrailManager.doDefaultTrail(playerConfig, particleDefaults, particle);
    }

    public static void doDefaultTrail(PlayerConfig playerConfig, ParticleEffect particle) {
        TrailManager.doDefaultTrail(playerConfig, TrailDefaults.getDefaults(particle), particle);
    }

    public static void doDefaultTrail(PlayerConfig playerConfig, TrailDefaults.ParticleDefaultStorage particleDefaults, ParticleEffect particle) {
        if (playerConfig.isScheduled()) {
            Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
            playerConfig.resetTaskId();
        }
        playerConfig.setParticle(particle);
        playerConfig.setType(particleDefaults.getType());
        playerConfig.setLength(particleDefaults.getLength());
        playerConfig.setHeight(particleDefaults.getHeight());
        playerConfig.setColour(particleDefaults.getColour());
        String trailName = particleDefaults.getDisplayName();
        if (!useTrailNameColour) {
            trailName = BUtil.stripColours(trailName);
        }
        BUtil.printPlain((CommandSender)Bukkit.getPlayer((UUID)playerConfig.getUuid()), msg.getString("messages.generic.trail-applied").replace("%trail%", trailName));
    }

    public static void loadTrail(Player player) {
        block7: {
            if (TrailManager.usingSQL()) {
                scheduler.runTaskAsynchronously((Plugin)BlivTrails.getInstance(), (Runnable)new LoadRunnable(player.getUniqueId()));
            } else {
                String data = flatFileStorage.loadEntry(player.getUniqueId().toString());
                if (data == null || data.isEmpty()) {
                    return;
                }
                try {
                    String[] dataSplit = data.split("[,]");
                    ParticleEffect particleEff = ParticleEffect.fromName(dataSplit[0]);
                    if (particleEff == ParticleEffect.FOOTSTEP) {
                        return;
                    }
                    trailMap.put(player.getUniqueId(), new PlayerConfig(player.getUniqueId(), particleEff, Integer.parseInt(dataSplit[1]), Integer.parseInt(dataSplit[2]), Integer.parseInt(dataSplit[3]), Integer.parseInt(dataSplit[4])));
                }
                catch (NumberFormatException e) {
                    BUtil.logError(player.getName() + " could not be loaded: One (or more) of the values were non-numerical.");
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    if (!BUtil.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
    }

    public static void saveTrail(OfflinePlayer player) {
        TrailManager.saveTrail(trailMap.get(player.getUniqueId()));
    }

    public static void saveTrail(PlayerConfig playerConfig) {
        if (playerConfig != null) {
            if (!playerConfig.hasValidParticle()) {
                TrailManager.removePlayer(playerConfig.getUuid());
                return;
            }
            if (TrailManager.usingSQL()) {
                SaveRunnable saveRunnable = new SaveRunnable(playerConfig.getUuid(), playerConfig);
                try {
                    scheduler.runTaskAsynchronously((Plugin)BlivTrails.getInstance(), (Runnable)saveRunnable);
                }
                catch (IllegalPluginAccessException e) {
                    saveRunnable.run();
                }
            } else {
                try {
                    flatFileStorage.saveEntry(playerConfig.getUuid().toString(), playerConfig.getParticle().toString() + "," + playerConfig.getType().getCfgId() + "," + playerConfig.getLength().getCfgId() + "," + playerConfig.getHeight().getCfgId() + "," + playerConfig.getColour());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static String addTrail(UUID uuid, String particleString, String typeString, String lengthString, String heightString, String colourString) {
        ParticleEffect particleEff = null;
        TrailDefaults.ParticleDefaultStorage particleDefaults = null;
        for (Map.Entry<ParticleEffect, TrailDefaults.ParticleDefaultStorage> entry : TrailDefaults.getParticleDefaults().entrySet()) {
            if (!BUtil.stripColours(entry.getValue().getDisplayName()).equalsIgnoreCase(particleString)) continue;
            particleEff = entry.getKey();
            particleDefaults = entry.getValue();
            break;
        }
        if (particleEff == null) {
            return ChatColor.RED + "Trail effect does not exist. (/trailadmin particles)";
        }
        OptionType type = OptionType.TYPE_TRACE;
        OptionType length = OptionType.LENGTH_SHORT;
        OptionType height = OptionType.HEIGHT_FEET;
        int colour = 0;
        if (particleEff == ParticleEffect.BARRIER) {
            return msg.getString("messages.generic.force-add-trail").replace("%player%", Bukkit.getOfflinePlayer((UUID)uuid).getName());
        }
        if (particleDefaults != null) {
            type = particleDefaults.getType();
            length = particleDefaults.getLength();
            height = particleDefaults.getHeight();
            colour = particleDefaults.getColour();
        }
        if (typeString != null && !typeString.isEmpty() && (type = OptionType.parseTypeString(typeString)) == OptionType.NONE) {
            return "\u00a7cInvalid Type | (trace, random, dynamic)";
        }
        if (lengthString != null && (length = OptionType.parseLengthString(lengthString)) == OptionType.NONE) {
            return "\u00a7cInvalid Length | (short, medium, long)";
        }
        if (heightString != null && (height = OptionType.parseHeightString(heightString)) == OptionType.NONE) {
            return "\u00a7cInvalid Height | (feet, waist, halo)";
        }
        if (colourString != null) {
            switch (colourString.toLowerCase()) {
                case "white": {
                    colour = 0;
                    break;
                }
                case "red": {
                    colour = 1;
                    break;
                }
                case "dark green": {
                    colour = 2;
                    break;
                }
                case "brown": {
                    colour = 3;
                    break;
                }
                case "dark blue": {
                    colour = 4;
                    break;
                }
                case "purple": {
                    colour = 5;
                    break;
                }
                case "cyan": {
                    colour = 6;
                    break;
                }
                case "light grey": 
                case "light gray": {
                    colour = 7;
                    break;
                }
                case "grey": 
                case "gray": {
                    colour = 8;
                    break;
                }
                case "pink": {
                    colour = 9;
                    break;
                }
                case "lime": {
                    colour = 10;
                    break;
                }
                case "yellow": {
                    colour = 11;
                    break;
                }
                case "light blue": {
                    colour = 12;
                    break;
                }
                case "magenta": {
                    colour = 13;
                    break;
                }
                case "orange": {
                    colour = 14;
                    break;
                }
                case "black": {
                    colour = 15;
                    break;
                }
                case "random": {
                    colour = 16;
                    break;
                }
                default: {
                    return "\u00a7cInvalid Colour. See /trailadmin colours | for colours";
                }
            }
        }
        trailMap.put(uuid, new PlayerConfig(uuid, particleEff, type, length, height, colour));
        return msg.getString("messages.generic.force-add-trail").replace("%player%", Bukkit.getOfflinePlayer((UUID)uuid).getName());
    }

    public static String removePlayer(UUID uuid) {
        return TrailManager.removePlayer(trailMap.remove(uuid));
    }

    public static String removePlayer(PlayerConfig playerConfig) {
        if (playerConfig != null) {
            try {
                if (playerConfig.isScheduled()) {
                    Bukkit.getScheduler().cancelTask(playerConfig.getTaskId());
                    playerConfig.resetTaskId();
                    playerConfig.setParticle(ParticleEffect.FOOTSTEP);
                }
                if (flatFileStorage == null) {
                    scheduler.runTaskAsynchronously((Plugin)BlivTrails.getInstance(), (Runnable)new RemoveRunnable(playerConfig.getUuid(), playerConfig));
                } else {
                    flatFileStorage.removeEntry(playerConfig.getUuid().toString());
                }
                return msg.getString("messages.generic.force-remove-receive").replace("%player%", Bukkit.getOfflinePlayer((UUID)playerConfig.getUuid()).getName());
            }
            catch (Exception e) {
                return msg.getString("messages.error.unexpected");
            }
        }
        return msg.getString("messages.error.player-no-trail");
    }

    public static boolean isVanished(Player player) {
        boolean isVanished = false;
        switch (vanishHook) {
            case VANISH_NO_PACKET: {
                try {
                    isVanished = ((VanishPlugin)Bukkit.getPluginManager().getPlugin("VanishNoPacket")).getManager().isVanished(player);
                }
                catch (NoClassDefFoundError | NullPointerException e) {
                    BUtil.logDebug("VanishNoPacket was called, but isn't loaded.");
                }
                break;
            }
            case ESSENTIALS: {
                break;
            }
        }
        return isVanished;
    }

    public static void addPlayerConfig(UUID uuid, PlayerConfig playerConfig) {
        trailMap.put(uuid, playerConfig);
    }

    public static PlayerConfig getPlayerConfig(UUID uuid) {
        return trailMap.get(uuid);
    }

    public static void removePlayerConfig(UUID uuid) {
        trailMap.remove(uuid);
    }

    public static Collection<PlayerConfig> getPlayerConfigs() {
        return trailMap.values();
    }

    public static double[] getOption() {
        return option;
    }

    public static float getTrailLength() {
        return trailLength;
    }

    public static VanishHook getVanishHook() {
        return vanishHook;
    }

    public static void setVanishHook(VanishHook vanishHook) {
        TrailManager.vanishHook = vanishHook;
    }

    static {
        useTrailNameColour = true;
        vanishHook = VanishHook.NONE;
    }

    public static enum VanishHook {
        NONE(0),
        VANISH_NO_PACKET(1),
        ESSENTIALS(2),
        SUPER_PREMIUM_VANISH(3);

        int hookType;

        private VanishHook(int hookType) {
            this.hookType = hookType;
        }

        public int getHookType() {
            return this.hookType;
        }
    }
}

