/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails;

import java.util.regex.Pattern;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.config.Messages;
import net.auscraft.BlivTrails.listeners.GUIListener;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TrailCommand
implements CommandExecutor {
    private FlatFile cfg = FlatFile.getInstance();
    private static final String BORDER_TOP = "\u00a78\u00a7m--------------\u00a76\u00a7l BlivTrails Admin \u00a78\u00a7m---------------";
    private static final String BORDER_BTM = "\u00a78\u00a7m--------------------------------------------";
    private static final String BORDER_LFT = "\u00a78| ";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("trail")) {
            GUIListener.mainMenu((Player)sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("trailadmin") && sender.hasPermission("blivtrails.admin")) {
            if (args.length == 0) {
                this.doMainMenu(sender);
                return true;
            }
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("particles")) {
                    StringBuilder output = new StringBuilder(" ");
                    for (ParticleEffect particleEff : TrailManager.usedTrails) {
                        output.append(this.cfg.getString("trails." + BUtil.trailConfigName(particleEff.toString()) + ".name").replaceAll("[ ]", "_")).append(", ");
                    }
                    sender.sendMessage("6Available Particles:\n\u00a7f" + BUtil.stripColours(output.toString()));
                } else if (args[0].equalsIgnoreCase("types")) {
                    sender.sendMessage("\u00a76Available Types:\u00a7ftrace, random, dynamic");
                } else if (args[0].equalsIgnoreCase("lengths")) {
                    sender.sendMessage("\u00a76Available Lengths:\u00a7fshort, medium, long");
                } else if (args[0].equalsIgnoreCase("heights")) {
                    sender.sendMessage("\u00a76Available Heights:\u00a7ffeet, waist, halo");
                } else if (args[0].equalsIgnoreCase("colours")) {
                    sender.sendMessage("\u00a76Available Colours:\n" + ChatColor.DARK_GREEN + "| \u00a7fblack, red, green, brown, blue, purple, cyan, light-grey/light-gray," + " grey/gray, pink, lime, yellow, light-blue, magenta, orange, white, random");
                } else {
                    if (args[0].equalsIgnoreCase("add")) {
                        if (args.length >= 3) {
                            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                            if (offlinePlayer == null || !offlinePlayer.isOnline()) {
                                BUtil.printError(sender, "Player is not currently online. Cannot add a trail to this player.");
                                return true;
                            }
                            Pattern underscorePattern = Pattern.compile("[_]");
                            String particle = underscorePattern.matcher(args[2]).replaceAll(" ");
                            if (args.length == 3) {
                                BUtil.printPlain(sender, TrailManager.addTrail(offlinePlayer.getUniqueId(), particle, null, null, null, null));
                                return true;
                            }
                            if (args.length >= 6) {
                                BUtil.printPlain(sender, BUtil.translateColours(TrailManager.addTrail(offlinePlayer.getUniqueId(), particle, args[3], args[4], args[5], args.length >= 7 ? args[6] : null)));
                                return true;
                            }
                        }
                        BUtil.printError(sender, "Usage: /trailadmin add <name> <trail> [<type> <length> <height> [<colour>]]");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("remove")) {
                        if (args.length > 1) {
                            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                            if (offlinePlayer == null || !offlinePlayer.isOnline()) {
                                BUtil.printError(sender, "Player is not currently online. Cannot remove this players trail.");
                                return true;
                            }
                            String message = TrailManager.removePlayer(offlinePlayer.getUniqueId());
                            if (message != null && !message.isEmpty()) {
                                sender.sendMessage(message);
                            }
                            return true;
                        }
                        BUtil.printError(sender, "Usage: /trailadmin remove <name>");
                    } else {
                        if (args[0].equalsIgnoreCase("reload")) {
                            if (FlatFile.getInstance().reloadFile()) {
                                BUtil.printError(sender, "You have config errors -- See Console for full printout");
                            }
                            Messages.getInstance().reloadFile();
                            TrailManager.loadDefaultOptions();
                            GUIListener.reload();
                            BUtil.printSuccess(sender, "Config and Messages Reloaded!");
                            return true;
                        }
                        this.doMainMenu(sender);
                    }
                }
            }
            return true;
        }
        return true;
    }

    private void doMainMenu(CommandSender sender) {
        sender.sendMessage("\u00a78\u00a7m--------------\u00a76\u00a7l BlivTrails Admin \u00a78\u00a7m---------------\n\u00a78| \u00a76/trailadmin reload \u00a7f- Reload Config and Messages\n\u00a78| \u00a76/trailadmin <particles|types|lengths|heights|colours>\n\u00a78| \u00a76/trailadmin remove <player> \u00a7f- Force remove a players trail\n\u00a78| \u00a76/trailadmin add <player> <particle> [type] [length] [height]\n\u00a78| \u00a76[colour] \u00a7f- Forcefully remove a players trail\n\u00a78| \u00a76\u00a7lNOTE: \u00a7fUse a '_' between words when defining particles\n\u00a78\u00a7m--------------------------------------------");
    }
}

