/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails;

import java.util.UUID;
import lombok.NonNull;
import net.auscraft.BlivTrails.OptionType;
import net.auscraft.BlivTrails.shade.ParticleEffect.ParticleEffect;

public class PlayerConfig {
    @NonNull
    private UUID uuid;
    private ParticleEffect particle = null;
    private OptionType type = OptionType.TYPE;
    private OptionType length = OptionType.LENGTH;
    private OptionType height = OptionType.HEIGHT;
    private int colour = 0;
    private boolean vanished = false;
    private int taskId = -1;
    private float trailTime = -1.0f;

    public PlayerConfig(UUID uuid, ParticleEffect particle, OptionType type, OptionType length, OptionType height, int colour) {
        this.uuid = uuid;
        this.particle = particle != null ? particle : ParticleEffect.FOOTSTEP;
        this.type = type;
        this.length = length;
        this.height = height;
        this.colour = colour;
    }

    public PlayerConfig(UUID uuid, ParticleEffect particle, int type, int length, int height, int colour) {
        this(uuid, particle, OptionType.getOptionType(OptionType.TYPE, type), OptionType.getOptionType(OptionType.LENGTH, length), OptionType.getOptionType(OptionType.HEIGHT, height), colour);
    }

    public PlayerConfig(UUID uuid) {
        this.uuid = uuid;
    }

    public OptionType getEnabledOption(OptionType optionType) {
        switch (optionType) {
            case TYPE: 
            case TYPE_TRACE: 
            case TYPE_RANDOM: 
            case TYPE_DYNAMIC: {
                return this.getType();
            }
            case LENGTH: 
            case LENGTH_SHORT: 
            case LENGTH_MEDIUM: 
            case LENGTH_LONG: {
                return this.getLength();
            }
            case HEIGHT: 
            case HEIGHT_FEET: 
            case HEIGHT_WAIST: 
            case HEIGHT_HALO: {
                return this.getHeight();
            }
        }
        return OptionType.TYPE;
    }

    public boolean isScheduled() {
        return this.taskId != -1;
    }

    public boolean hasValidParticle() {
        return this.particle != null && this.particle != ParticleEffect.FOOTSTEP;
    }

    public boolean canSpawnParticle() {
        return this.trailTime > 0.0f;
    }

    public void resetTaskId() {
        this.taskId = -1;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    public ParticleEffect getParticle() {
        return this.particle;
    }

    public void setParticle(ParticleEffect particle) {
        this.particle = particle;
    }

    public OptionType getType() {
        return this.type;
    }

    public void setType(OptionType type) {
        this.type = type;
    }

    public OptionType getLength() {
        return this.length;
    }

    public void setLength(OptionType length) {
        this.length = length;
    }

    public OptionType getHeight() {
        return this.height;
    }

    public void setHeight(OptionType height) {
        this.height = height;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }

    public boolean isVanished() {
        return this.vanished;
    }

    public void setVanished(boolean vanished) {
        this.vanished = vanished;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public float getTrailTime() {
        return this.trailTime;
    }

    public void setTrailTime(float trailTime) {
        this.trailTime = trailTime;
    }
}

