/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails;

import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.listeners.GUIListener;
import net.auscraft.BlivTrails.util.GUIUtil;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemListener
implements Listener {
    private TrailManager listener;
    private ItemStack guiItem = null;
    private int guiItemSlot = 0;
    private Material guiItemMaterial;
    private String guiItemDisplayname;

    public ItemListener() {
        GUIUtil.ItemContainer tempContainer;
        FlatFile cfg = FlatFile.getInstance();
        if (cfg.getConfigurationSection("misc.gui-item") != null && (tempContainer = GUIUtil.ItemContainer.buildItemContainer(cfg.getConfigurationSection("misc.gui-item"), true)) != null) {
            this.guiItem = tempContainer.toItemStack(null);
            ItemMeta itemMeta = this.guiItem.getItemMeta();
            this.guiItemMaterial = this.guiItem.getType();
            this.guiItemDisplayname = itemMeta.getDisplayName();
            this.guiItemSlot = cfg.getInt("misc.gui-item.position");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerUse(PlayerInteractEvent event) {
        if ((event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) && this.guiItem != null) {
            if (event.getItem() == null || event.getItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            Player player = event.getPlayer();
            if (event.getItem().getType() == this.guiItemMaterial && event.getItem().getItemMeta().getDisplayName().equals(this.guiItemDisplayname)) {
                event.setCancelled(true);
                GUIListener.mainMenu(player);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.guiItem != null && !event.getPlayer().getInventory().contains(this.guiItem)) {
            if (event.getPlayer().getInventory().getItem(this.guiItemSlot) != null) {
                event.getPlayer().getInventory().addItem(new ItemStack[]{this.guiItem});
            } else {
                event.getPlayer().getInventory().setItem(this.guiItemSlot, this.guiItem);
            }
        }
    }
}

