/*
 * Decompiled with CFR 0.152.
 */
package net.auscraft.BlivTrails;

import java.sql.SQLException;
import java.util.Random;
import net.auscraft.BlivTrails.ItemListener;
import net.auscraft.BlivTrails.PlayerConfig;
import net.auscraft.BlivTrails.TrailCommand;
import net.auscraft.BlivTrails.TrailManager;
import net.auscraft.BlivTrails.config.FlatFile;
import net.auscraft.BlivTrails.config.FlatFileStorage;
import net.auscraft.BlivTrails.config.Messages;
import net.auscraft.BlivTrails.config.TrailDefaults;
import net.auscraft.BlivTrails.hooks.EssentialsListener;
import net.auscraft.BlivTrails.hooks.SuperPremiumVanishListener;
import net.auscraft.BlivTrails.hooks.VanishNoPacketListener;
import net.auscraft.BlivTrails.listeners.GUIListener;
import net.auscraft.BlivTrails.listeners.TrailListener;
import net.auscraft.BlivTrails.shade.ormlite.jdbc.JdbcPooledConnectionSource;
import net.auscraft.BlivTrails.shade.ormlite.support.ConnectionSource;
import net.auscraft.BlivTrails.shade.ormlite.table.TableUtils;
import net.auscraft.BlivTrails.storage.ParticleData;
import net.auscraft.BlivTrails.storage.ParticleStorage;
import net.auscraft.BlivTrails.util.BUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BlivTrails
extends JavaPlugin {
    private static BlivTrails instance = null;
    private static JdbcPooledConnectionSource ds = null;
    private static FlatFileStorage flatFileStorage = null;
    private Messages messages;
    public static final Random rand = new Random();
    private ParticleStorage particleStorage;
    private int trailTimeoutCheckTime = 20;

    public void onEnable() {
        instance = this;
        this.messages = Messages.getInstance();
        FlatFile cfg = FlatFile.getInstance();
        BUtil.DEBUG = cfg.getBoolean("misc.debug");
        BUtil.setPlayerPrefix(BUtil.translateColours(this.messages.getString("messages.prefix")));
        if (cfg.getBoolean("database.mysql")) {
            BUtil.logInfo("Using MySQL as the storage option");
            this.disableDatabaseLogging();
            try {
                this.sqlSetup();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
        } else {
            BUtil.logInfo("Using FlatFile as the storage option");
            flatFileStorage = FlatFileStorage.getInstance();
        }
        TrailManager.init();
        TrailDefaults.getInstance();
        this.getServer().getPluginManager().registerEvents((Listener)new TrailListener(), (Plugin)this);
        GUIListener.reload();
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        this.getCommand("trail").setExecutor((CommandExecutor)new TrailCommand());
        this.getCommand("trailadmin").setExecutor((CommandExecutor)new TrailCommand());
        this.doHooks();
        if (!cfg.getBoolean("trails.misc.display-when-still")) {
            this.trailTimeoutCheckTime = cfg.getInt("trails.scheduler.check-time");
            this.doTrailTimeouts();
        }
    }

    public void onDisable() {
        TrailManager.doDisable();
        try {
            ds.closeQuietly();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void doItemListener() {
        this.getServer().getPluginManager().registerEvents((Listener)new ItemListener(), (Plugin)this);
    }

    private void doHooks() {
        try {
            PluginManager pluginManager = this.getServer().getPluginManager();
            if (pluginManager.getPlugin("VanishNoPacket") != null) {
                pluginManager.registerEvents((Listener)new VanishNoPacketListener(), (Plugin)this);
            } else if (pluginManager.isPluginEnabled("SuperVanish") || pluginManager.isPluginEnabled("PremiumVanish")) {
                pluginManager.registerEvents((Listener)new SuperPremiumVanishListener(), (Plugin)this);
            } else if (pluginManager.getPlugin("Essentials") != null) {
                pluginManager.registerEvents((Listener)new EssentialsListener(), (Plugin)this);
            } else {
                BUtil.logInfo("No Vanish Plugin Hooked.");
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void sqlSetup() throws SQLException {
        FlatFile cfg = FlatFile.getInstance();
        ds = new JdbcPooledConnectionSource(cfg.getString("database.url"));
        if (!cfg.getString("database.username").isEmpty()) {
            ds.setUsername(cfg.getString("database.username"));
        }
        if (!cfg.getString("database.password").isEmpty()) {
            ds.setPassword(cfg.getString("database.password"));
        }
        ds.setMaxConnectionsFree(3);
        ds.setTestBeforeGet(false);
        ds.setMaxConnectionAgeMillis(900000L);
        ds.setCheckConnectionsEveryMillis(0L);
        ds.initialize();
        this.particleStorage = new ParticleStorage(ds);
        if (!this.particleStorage.isTableExists()) {
            TableUtils.createTable((ConnectionSource)ds, ParticleData.class);
        }
    }

    public static Object getSave() {
        if (ds != null) {
            return ds;
        }
        return flatFileStorage;
    }

    private void disableDatabaseLogging() {
        System.setProperty("net.auscraft.BlivTrails.shade.ormlite.logger.level", "INFO");
    }

    private void doTrailTimeouts() {
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                BukkitScheduler scheduler = Bukkit.getScheduler();
                for (PlayerConfig playerConfig : TrailManager.getPlayerConfigs()) {
                    if (!playerConfig.isScheduled()) continue;
                    int taskId = playerConfig.getTaskId();
                    if (scheduler.isQueued(taskId) || scheduler.isCurrentlyRunning(taskId)) {
                        float resultingTime = playerConfig.getTrailTime() - (float)BlivTrails.this.trailTimeoutCheckTime;
                        if (resultingTime > 0.0f) {
                            playerConfig.setTrailTime(resultingTime);
                            continue;
                        }
                        scheduler.cancelTask(taskId);
                    }
                    playerConfig.resetTaskId();
                }
            }
        }, 20L, (long)this.trailTimeoutCheckTime * 20L);
    }

    public static BlivTrails getInstance() {
        return instance;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public ParticleStorage getParticleStorage() {
        return this.particleStorage;
    }
}

