/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.itembuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.inventivetalent.itembuilder.BannerMetaBuilder;
import org.inventivetalent.itembuilder.BookMetaBuilder;
import org.inventivetalent.itembuilder.FireworkEffectMetaBuilder;
import org.inventivetalent.itembuilder.FireworkMetaBuilder;
import org.inventivetalent.itembuilder.ItemBuilder;
import org.inventivetalent.itembuilder.LeatherArmorMetaBuilder;
import org.inventivetalent.itembuilder.MapMetaBuilder;
import org.inventivetalent.itembuilder.PotionMetaBuilder;
import org.inventivetalent.itembuilder.Reflection;
import org.inventivetalent.itembuilder.SkullMetaBuilder;

public class MetaBuilder {
    @Nullable
    protected ItemBuilder itemBuilder;
    protected ItemMeta meta;
    private final Class<?> CraftMetaItem = Reflection.getOBCClass("inventory.CraftMetaItem");

    public MetaBuilder() {
    }

    public MetaBuilder(ItemStack itemStack) {
        this.forItem(itemStack);
    }

    public MetaBuilder(ItemBuilder itemBuilder) {
        this.forItem(itemBuilder);
    }

    protected void validateInit() {
        if (this.meta == null) {
            throw new IllegalStateException("Meta not yet initiated");
        }
    }

    public MetaBuilder fromConfig(ConfigurationSection section) {
        return this.fromConfig(section, true);
    }

    public MetaBuilder fromConfig(ConfigurationSection section, boolean translateColors) {
        if (section.contains("display")) {
            this.withDisplayName(this.translateColors(section.getString("display"), translateColors));
        }
        if (section.contains("lore")) {
            if (translateColors) {
                ArrayList<String> translated = new ArrayList<String>();
                for (String s : section.getStringList("lore")) {
                    translated.add(this.translateColors(s, translateColors));
                }
                this.withLore(translated);
            } else {
                this.withLore(section.getStringList("lore"));
            }
        }
        if (section.contains("flags")) {
            List flagStrings = section.getStringList("flags");
            for (String s : flagStrings) {
                ItemFlag flag = null;
                try {
                    flag = ItemFlag.valueOf((String)s.toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (flag == null) continue;
                this.withItemFlags(flag);
            }
        }
        if (section.contains("enchants")) {
            List enchantStrings = section.getStringList("enchants");
            for (String s : enchantStrings) {
                String enchantName = "";
                String enchantOptions = "";
                int level = 1;
                boolean force = false;
                if (s.contains("x")) {
                    String[] split = s.split("x");
                    enchantName = split[0];
                    enchantOptions = split[1];
                }
                if (force = enchantName.contains("-f")) {
                    enchantName = enchantName.split("-f")[0];
                }
                if (enchantOptions.contains("-f")) {
                    force = true;
                    try {
                        level = Integer.parseInt(enchantOptions.split("-f")[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Enchantment enchantment = null;
                try {
                    enchantment = Enchantment.getByName((String)enchantName.toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (enchantment == null) continue;
                this.withEnchant(enchantment, level, force);
            }
        }
        return this;
    }

    public MetaBuilder forItem(ItemStack itemStack) {
        this.meta = itemStack.getItemMeta();
        return this;
    }

    public MetaBuilder forItem(ItemBuilder itemBuilder) {
        itemBuilder.validateInit();
        this.meta = itemBuilder.itemStack.getItemMeta();
        this.itemBuilder = itemBuilder;
        return this;
    }

    public MetaBuilder withDisplayName(String displayName) {
        this.validateInit();
        this.meta.setDisplayName(displayName);
        return this;
    }

    public MetaBuilder withLore(List<String> lore) {
        this.validateInit();
        this.meta.setLore(lore);
        return this;
    }

    public MetaBuilder withLore(String ... lore) {
        this.validateInit();
        ArrayList<String> currentLore = this.meta.getLore();
        if (currentLore == null) {
            currentLore = new ArrayList<String>();
        }
        currentLore.addAll(Arrays.asList(lore));
        return this.withLore(currentLore);
    }

    public MetaBuilder withItemFlags(ItemFlag ... flags) {
        this.validateInit();
        this.meta.addItemFlags(flags);
        return this;
    }

    public MetaBuilder withEnchant(Enchantment enchant, int level, boolean force) {
        this.validateInit();
        this.meta.addEnchant(enchant, level, force);
        return this;
    }

    public <T extends MetaBuilder> T convert(Class<? extends ItemMeta> metaClazz) throws IllegalArgumentException {
        if (ItemMeta.class.equals(metaClazz) || this.CraftMetaItem.equals(metaClazz)) {
            return (T)this;
        }
        if (SkullMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new SkullMetaBuilder(this);
        }
        if (BannerMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new BannerMetaBuilder(this);
        }
        if (PotionMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new PotionMetaBuilder(this);
        }
        if (MapMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new MapMetaBuilder(this);
        }
        if (BookMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new BookMetaBuilder(this);
        }
        if (LeatherArmorMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new LeatherArmorMetaBuilder(this);
        }
        if (FireworkMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new FireworkMetaBuilder(this);
        }
        if (FireworkEffectMeta.class.isAssignableFrom(metaClazz)) {
            return (T)new FireworkEffectMetaBuilder(this);
        }
        throw new IllegalArgumentException("No meta builder found for class " + metaClazz.getName());
    }

    public <T extends MetaBuilder> T convertBuilder(Class<T> metaClazz) throws IllegalArgumentException {
        if (MetaBuilder.class.equals(metaClazz)) {
            return (T)this;
        }
        try {
            return (T)((MetaBuilder)metaClazz.getDeclaredConstructor(MetaBuilder.class).newInstance(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("No meta builder found for class " + metaClazz.getName());
        }
    }

    @Nullable
    public ItemBuilder item() {
        if (this.itemBuilder != null) {
            this.itemBuilder.withMeta(this);
        }
        return this.itemBuilder;
    }

    public ItemMeta build() {
        this.validateInit();
        return this.meta;
    }

    protected String translateColors(String string, boolean translate) {
        return translate ? ChatColor.translateAlternateColorCodes((char)'&', (String)string) : string;
    }
}

