/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.itembuilder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.inventivetalent.itembuilder.ItemBuilder;
import org.inventivetalent.itembuilder.MetaBuilder;

public class LeatherArmorMetaBuilder
extends MetaBuilder {
    final Pattern RGB_PATTERN = Pattern.compile("R:([0-9]+) G:([0-9]+) B:([0-9]+)");

    public LeatherArmorMetaBuilder() {
    }

    public LeatherArmorMetaBuilder(ItemStack itemStack) {
        super(itemStack);
    }

    public LeatherArmorMetaBuilder(ItemBuilder itemBuilder) {
        super(itemBuilder);
    }

    protected LeatherArmorMetaBuilder(MetaBuilder builder) {
        this.meta = builder.meta;
        this.itemBuilder = builder.itemBuilder;
    }

    private LeatherArmorMeta getMeta() {
        return (LeatherArmorMeta)this.meta;
    }

    @Override
    public LeatherArmorMetaBuilder fromConfig(ConfigurationSection section, boolean translateColors) {
        super.fromConfig(section, translateColors);
        if (section.contains("color")) {
            String colorString = section.getString("color");
            DyeColor dyeColor = null;
            try {
                dyeColor = DyeColor.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception e) {
                // empty catch block
            }
            Color color = null;
            if (dyeColor != null) {
                color = dyeColor.getColor();
            } else {
                Matcher matcher = this.RGB_PATTERN.matcher(colorString);
                if (matcher.groupCount() == 3) {
                    int r = Integer.parseInt(matcher.group(0));
                    int g = Integer.parseInt(matcher.group(1));
                    int b = Integer.parseInt(matcher.group(2));
                    color = Color.fromRGB((int)r, (int)g, (int)b);
                }
            }
            if (color != null) {
                this.withColor(color);
            }
        }
        return this;
    }

    public LeatherArmorMetaBuilder withColor(Color color) {
        this.validateInit();
        this.getMeta().setColor(color);
        return this;
    }

    public LeatherArmorMeta build() {
        return (LeatherArmorMeta)super.build();
    }
}

