/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.itembuilder;

import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.inventivetalent.itembuilder.MetaBuilder;

public class ItemBuilder {
    ItemStack itemStack;

    public ItemBuilder() {
    }

    public ItemBuilder(int typeId) {
        this.withTypeId(typeId);
    }

    public ItemBuilder(Material material) {
        this.withType(material);
    }

    public ItemBuilder(Material material, int amount) {
        this(material);
        this.withAmount(amount);
    }

    public ItemBuilder(Material material, int amount, int durability) {
        this(material, amount);
        this.withDurability(durability);
    }

    private void initItem(int id) {
        if (this.itemStack == null) {
            this.itemStack = new ItemStack(id);
        }
    }

    void validateInit() {
        if (this.itemStack == null) {
            throw new IllegalStateException("Item is not yet initiated (Missing material)");
        }
    }

    public ItemBuilder fromConfig(ConfigurationSection section) {
        if (section.contains("type")) {
            if (section.isInt("type")) {
                this.withTypeId(section.getInt("type"));
            }
            if (section.isString("type")) {
                Material material = null;
                try {
                    material = Material.valueOf((String)section.getString("type").toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (material != null) {
                    this.withType(material);
                }
            }
        }
        if (section.contains("amount") && section.isInt("amount")) {
            this.withAmount(section.getInt("amount"));
        }
        if (section.contains("durability") && section.isInt("durability")) {
            this.withDurability(section.getInt("durability"));
        }
        if (section.contains("meta") && section.isConfigurationSection("meta")) {
            ConfigurationSection meta = section.getConfigurationSection("meta");
            MetaBuilder metaBuilder = this.buildMeta();
            metaBuilder.fromConfig(meta);
            this.withMeta(metaBuilder);
        }
        return this;
    }

    public ItemBuilder withTypeId(int id) {
        this.initItem(id);
        return this;
    }

    public ItemBuilder withType(Material material) {
        this.initItem(material.getId());
        return this;
    }

    public ItemBuilder withAmount(int amount) {
        this.validateInit();
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder withDurability(int durability) {
        this.validateInit();
        this.itemStack.setDurability((short)durability);
        return this;
    }

    public ItemBuilder withData(MaterialData data) {
        this.validateInit();
        this.itemStack.setData(data);
        return this;
    }

    public MetaBuilder buildMeta() {
        return new MetaBuilder(this).convert(this.itemStack.getItemMeta().getClass());
    }

    public <T extends MetaBuilder> T buildMeta(Class<T> metaClazz) {
        return this.buildMeta().convertBuilder(metaClazz);
    }

    public ItemBuilder withMeta(ItemMeta meta) {
        this.validateInit();
        this.itemStack.setItemMeta(meta);
        return this;
    }

    public ItemBuilder withMeta(MetaBuilder meta) {
        this.validateInit();
        this.itemStack.setItemMeta(meta.build());
        return this;
    }

    public ItemStack build() {
        this.validateInit();
        return this.itemStack;
    }
}

