/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.itembuilder;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.inventivetalent.itembuilder.ItemBuilder;
import org.inventivetalent.itembuilder.MetaBuilder;

public class BookMetaBuilder
extends MetaBuilder {
    public BookMetaBuilder() {
    }

    public BookMetaBuilder(ItemStack itemStack) {
        super(itemStack);
    }

    public BookMetaBuilder(ItemBuilder itemBuilder) {
        super(itemBuilder);
    }

    protected BookMetaBuilder(MetaBuilder builder) {
        this.meta = builder.meta;
        this.itemBuilder = builder.itemBuilder;
    }

    private BookMeta getMeta() {
        return (BookMeta)this.meta;
    }

    @Override
    public BookMetaBuilder fromConfig(ConfigurationSection section, boolean translateColors) {
        super.fromConfig(section, translateColors);
        if (section.contains("author")) {
            this.withAuthor(this.translateColors(section.getString("author"), translateColors));
        }
        if (section.contains("title")) {
            this.withTitle(this.translateColors(section.getString("title"), translateColors));
        }
        if (section.contains("pages")) {
            List pageStrings = section.getStringList("pages");
            if (translateColors) {
                ArrayList<String> translated = new ArrayList<String>();
                for (String s : pageStrings) {
                    translated.add(this.translateColors(s, translateColors));
                }
                this.withPages(translated);
            } else {
                this.withPages(pageStrings);
            }
        }
        return this;
    }

    public BookMetaBuilder withTitle(String title) {
        this.validateInit();
        this.getMeta().setTitle(title);
        return this;
    }

    public BookMetaBuilder withAuthor(String author) {
        this.validateInit();
        this.getMeta().setAuthor(author);
        return this;
    }

    public BookMetaBuilder withPage(int page, String content) {
        this.validateInit();
        this.getMeta().setPage(page, content);
        return this;
    }

    public BookMetaBuilder withPages(List<String> pages) {
        this.validateInit();
        this.getMeta().setPages(pages);
        return this;
    }

    public BookMetaBuilder withPage(String ... pages) {
        this.validateInit();
        this.getMeta().addPage(pages);
        return this;
    }

    public BookMetaBuilder withPages(String ... pages) {
        this.validateInit();
        this.getMeta().setPages(pages);
        return this;
    }

    public BookMeta build() {
        return (BookMeta)super.build();
    }
}

