/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.itembuilder;

import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.inventivetalent.itembuilder.ItemBuilder;
import org.inventivetalent.itembuilder.MetaBuilder;

public class BannerMetaBuilder
extends MetaBuilder {
    public BannerMetaBuilder() {
    }

    public BannerMetaBuilder(ItemStack itemStack) {
        super(itemStack);
    }

    public BannerMetaBuilder(ItemBuilder itemBuilder) {
        super(itemBuilder);
    }

    protected BannerMetaBuilder(MetaBuilder builder) {
        this.meta = builder.meta;
        this.itemBuilder = builder.itemBuilder;
    }

    private BannerMeta getMeta() {
        return (BannerMeta)this.meta;
    }

    @Override
    public BannerMetaBuilder fromConfig(ConfigurationSection section, boolean translateColors) {
        super.fromConfig(section, translateColors);
        if (section.contains("patterns")) {
            List patternStrings = section.getStringList("patterns");
            for (String s : patternStrings) {
                String[] split = s.split("-");
                if (split.length != 2) continue;
                String patternName = split[0];
                String colorName = split[1];
                PatternType patternType = null;
                try {
                    patternType = PatternType.valueOf((String)patternName.toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                DyeColor color = null;
                try {
                    color = DyeColor.valueOf((String)colorName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (patternType == null || color == null) continue;
                Pattern pattern = new Pattern(color, patternType);
                this.withPattern(pattern);
            }
        }
        return this;
    }

    public BannerMetaBuilder withBaseColor(DyeColor baseColor) {
        this.validateInit();
        this.getMeta().setBaseColor(baseColor);
        return this;
    }

    public BannerMetaBuilder withPattern(Pattern ... patterns) {
        this.validateInit();
        for (Pattern pattern : patterns) {
            this.getMeta().addPattern(pattern);
        }
        return this;
    }

    public BannerMeta build() {
        return (BannerMeta)super.build();
    }
}

