/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.flickeringpumpkins;

import de.inventivegames.particle.ParticleEffect;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.inventivetalent.flickeringpumpkins.FlickeringPumpkins;

public class PumpkinScheduler
extends BukkitRunnable {
    public Set<Location> locations = new HashSet<Location>();
    private FlickeringPumpkins plugin;
    private Random random = new Random();

    public PumpkinScheduler(FlickeringPumpkins plugin) {
        this.plugin = plugin;
    }

    public void run() {
        Iterator<Location> iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            Location particleLocation;
            Location location = iterator.next();
            Block block = location.getBlock();
            if (block == null) {
                iterator.remove();
                continue;
            }
            if (block.getType() != Material.PUMPKIN && block.getType() != Material.JACK_O_LANTERN) {
                iterator.remove();
                continue;
            }
            int rnd = this.plugin.probability > 0 ? this.random.nextInt(this.plugin.probability) : 0;
            if (rnd != 0) continue;
            if (block.getType() == Material.PUMPKIN) {
                block.setTypeIdAndData(Material.JACK_O_LANTERN.getId(), block.getData(), false);
                for (int i = 0; i < 10; ++i) {
                    particleLocation = location.clone().add(0.5, 0.5, 0.5).add(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble()).subtract(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
                    try {
                        ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.YELLOW, true);
                        ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.ORANGE, true);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (block.getType() != Material.JACK_O_LANTERN) continue;
            block.setTypeIdAndData(Material.PUMPKIN.getId(), block.getData(), false);
            for (int i = 0; i < 10; ++i) {
                particleLocation = location.clone().add(0.5, 0.5, 0.5).add(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble()).subtract(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
                try {
                    ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.black, true);
                    ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.RED, true);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (Bukkit.getOnlinePlayers().isEmpty() || this.random.nextInt(10) != 0) continue;
            final Bat bat = (Bat)location.getWorld().spawn(location.clone().add(0.5, 1.5, 0.5), Bat.class);
            bat.setMaxHealth(2048.0);
            bat.setHealth(2048.0);
            new BukkitRunnable(){
                int count = 0;

                public void run() {
                    if (bat.isDead()) {
                        this.cancel();
                        return;
                    }
                    if (this.count > 20) {
                        bat.teleport(new Location(bat.getWorld(), 0.0, -20.0, 0.0));
                        bat.setHealth(0.0);
                        bat.remove();
                    }
                    ++this.count;
                    if (PumpkinScheduler.this.random.nextInt(10) == 0) {
                        for (int i = 0; i < 10; ++i) {
                            Location particleLocation = bat.getLocation().clone().add(PumpkinScheduler.this.random.nextDouble(), PumpkinScheduler.this.random.nextDouble(), PumpkinScheduler.this.random.nextDouble()).subtract(PumpkinScheduler.this.random.nextDouble(), PumpkinScheduler.this.random.nextDouble(), PumpkinScheduler.this.random.nextDouble());
                            try {
                                ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.black, true);
                                ParticleEffect.RED_DUST.sendColor((Collection<? extends Player>)Bukkit.getOnlinePlayers(), particleLocation, Color.RED, true);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 10L, 10L);
        }
    }
}

