/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.flickeringpumpkins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.inventivetalent.flickeringpumpkins.CommandHandler;
import org.inventivetalent.flickeringpumpkins.PumpkinListener;
import org.inventivetalent.flickeringpumpkins.PumpkinScheduler;
import org.inventivetalent.itembuilder.ItemBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mcstats.MetricsLite;

public class FlickeringPumpkins
extends JavaPlugin {
    public long interval = 40L;
    public int probability = 50;
    public PumpkinScheduler scheduler;
    public ItemStack pumpkinItem = new ItemBuilder(Material.JACK_O_LANTERN).buildMeta().withDisplayName("\u00a76Flickering Pumpkin").withLore("\u00a7r\u00a77Place down to create a \u00a76Flickering punkpkin").item().build();
    private File pumpkinFile = new File(this.getDataFolder(), "pumpkins.json");

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new PumpkinListener(this), (Plugin)this);
        this.saveDefaultConfig();
        this.interval = this.getConfig().getLong("interval");
        this.probability = this.getConfig().getInt("probability");
        this.probability = Math.min(100, Math.max(0, 100 - this.probability));
        CommandHandler commandHandler = new CommandHandler(this);
        PluginCommand command = this.getCommand("flickeringpumpkins");
        command.setExecutor((CommandExecutor)commandHandler);
        command.setTabCompleter((TabCompleter)commandHandler);
        if (!this.pumpkinFile.exists()) {
            try {
                this.pumpkinFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.scheduler = new PumpkinScheduler(this);
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(FlickeringPumpkins.this.pumpkinFile));
                    String content = "";
                    while ((line = reader.readLine()) != null) {
                        content = content + line;
                    }
                    reader.close();
                    if (!content.isEmpty() && content.startsWith("[") && content.endsWith("]")) {
                        JSONArray array = new JSONArray(content);
                        for (int i = 0; i < array.length(); ++i) {
                            Location location = FlickeringPumpkins.this.JSONToLocation(array.getJSONObject(i));
                            if (location == null || location.getWorld() == null) continue;
                            FlickeringPumpkins.this.scheduler.locations.add(location);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FlickeringPumpkins.this.scheduler.runTaskTimer((Plugin)FlickeringPumpkins.this, FlickeringPumpkins.this.interval, FlickeringPumpkins.this.interval);
            }
        }, 20L);
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            if (metrics.start()) {
                this.getLogger().info("Metrics started");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisable() {
        JSONArray array = new JSONArray();
        for (Location location : this.scheduler.locations) {
            array.put(this.LocationToJSON(location));
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.pumpkinFile));
            writer.write(array.toString(2));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    JSONObject LocationToJSON(final Location location) {
        return new JSONObject(){
            {
                this.put("world", location.getWorld().getName());
                this.put("x", location.getX());
                this.put("y", location.getY());
                this.put("z", location.getZ());
                this.put("yaw", location.getYaw());
                this.put("pitch", location.getPitch());
            }
        };
    }

    Location JSONToLocation(JSONObject json) {
        String world = json.getString("world");
        double x = json.getDouble("x");
        double y = json.getDouble("y");
        double z = json.getDouble("z");
        float yaw = (float)json.getDouble("yaw");
        float pitch = (float)json.getDouble("pitch");
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }
}

