/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import ru.Den_Abr.ChatGuard.Configuration.Messages;

public class Utils {
    public static void clearChat(Player p) {
        int i = 0;
        while (i < 100) {
            p.sendMessage("");
            ++i;
        }
    }

    public static String readLine(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            return StringUtils.join((Collection)Files.readLines((File)f, (Charset)StandardCharsets.UTF_8), (String)"");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<Player> getOnlinePlayers() {
        Collection<Object> playersOnline = new ArrayList<Player>();
        try {
            playersOnline = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).getReturnType() == Collection.class ? (Collection)Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]) : Arrays.asList((Player[])Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return playersOnline;
    }

    public static String replaceFirstSafely(String where, String s, String string) {
        if (!where.contains(s)) {
            return where;
        }
        String ns = String.valueOf(where.substring(0, where.indexOf(s))) + string + where.substring(s.length() + where.indexOf(s), where.length());
        return ns;
    }

    public static String getOriginalCommand(String lowerCase) {
        Object[] splitted = lowerCase.split(" ");
        String first = splitted[0];
        PluginCommand pc = Bukkit.getPluginCommand((String)first);
        if (pc != null) {
            splitted[0] = first = pc.getName();
            lowerCase = StringUtils.join((Object[])splitted, (char)' ');
        }
        return lowerCase;
    }

    public static String getWord(String message, int start, int end) {
        int wordStart = 0;
        int wordEnd = message.length();
        char[] chars = message.toCharArray();
        int i = start;
        while (i >= 0) {
            if (chars[i] == ' ') {
                wordStart = i;
                break;
            }
            --i;
        }
        i = end;
        while (i < message.length()) {
            if (chars[i] == ' ') {
                wordEnd = i;
                break;
            }
            ++i;
        }
        String word = message.substring(wordStart, wordEnd);
        return word.trim();
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long parseTime(String time) {
        String number;
        String unit;
        if (time.length() > 1) {
            unit = time.substring(time.length() - 1).toLowerCase();
            number = time.substring(0, time.length() - 1);
        } else {
            unit = "s";
            number = time;
        }
        if (!Utils.isInt(number)) {
            return Long.MIN_VALUE;
        }
        int ch = Integer.parseInt(number);
        long result = Long.MIN_VALUE;
        switch (unit) {
            case "s": {
                result = TimeUnit.SECONDS.toMillis(ch);
                break;
            }
            case "m": {
                result = TimeUnit.MINUTES.toMillis(ch);
                break;
            }
            case "h": {
                result = TimeUnit.HOURS.toMillis(ch);
                break;
            }
            case "d": {
                result = TimeUnit.DAYS.toMillis(ch);
                break;
            }
            default: {
                result = TimeUnit.SECONDS.toMillis(Utils.isInt(time) ? Integer.parseInt(time) : ch);
            }
        }
        return result;
    }

    public static String translateTime(String time) {
        String number;
        String unit;
        if (time.length() > 1) {
            unit = time.substring(time.length() - 1).toLowerCase();
            number = time.substring(0, time.length() - 1);
        } else {
            unit = "s";
            number = time;
        }
        int ch = Integer.parseInt(number);
        return Utils.translateByLastDigit(ch, unit);
    }

    public static String translateByLastDigit(int ch, String unit2) {
        String unit;
        switch (unit2) {
            case "s": {
                unit = Messages.Message.SEC.get();
                break;
            }
            case "m": {
                unit = Messages.Message.MINUTES.get();
                break;
            }
            case "h": {
                unit = Messages.Message.HOURS.get();
                break;
            }
            case "d": {
                unit = Messages.Message.DAYS.get();
                break;
            }
            default: {
                unit = "ms.";
            }
        }
        return String.valueOf(ch) + " " + unit;
    }

    public static String getTimeInMaxUnit(long time) {
        int ch = 0;
        if (TimeUnit.MILLISECONDS.toDays(time) > 0L) {
            ch = (int)TimeUnit.MILLISECONDS.toDays(time);
            return Utils.translateByLastDigit(ch, "d");
        }
        if (TimeUnit.MILLISECONDS.toHours(time) > 0L) {
            ch = (int)TimeUnit.MILLISECONDS.toHours(time);
            return Utils.translateByLastDigit(ch, "h");
        }
        if (TimeUnit.MILLISECONDS.toMinutes(time) > 0L) {
            ch = (int)TimeUnit.MILLISECONDS.toMinutes(time);
            return Utils.translateByLastDigit(ch, "m");
        }
        if (TimeUnit.MILLISECONDS.toSeconds(time) > 0L) {
            ch = (int)TimeUnit.MILLISECONDS.toSeconds(time);
            return Utils.translateByLastDigit(ch, "s");
        }
        ch = (int)time;
        return String.valueOf(ch) + "ms.";
    }
}

