/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Player;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Player.LegacyChatPlayer;
import ru.Den_Abr.ChatGuard.Utils.FixedSizeList;
import ru.Den_Abr.ChatGuard.Utils.MessagePair;
import ru.Den_Abr.ChatGuard.Utils.Utils;
import ru.Den_Abr.ChatGuard.Violation;

public abstract class CGPlayer {
    private static List<CGPlayer> cache = new LinkedList<CGPlayer>();
    private FixedSizeList<String> lastMessages = new FixedSizeList(1);
    private FixedSizeList<MessagePair> sentMessages = new FixedSizeList(100);
    private FixedSizeList<String> allMessages = new FixedSizeList(100);
    private List<Violation> violations = new ArrayList<Violation>();
    protected long lastMessage = -1L;
    protected long muteTime = -1L;
    private String muteReason;

    public abstract boolean hasPermission(String var1);

    public abstract String getName();

    public abstract Player getPlayer();

    public abstract void updatePlayer(Player var1);

    public long getLastMessageTime() {
        return this.lastMessage;
    }

    public void setLastMessageTime(long time) {
        this.lastMessage = time;
    }

    public FixedSizeList<String> getLastMessages() {
        return this.lastMessages;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public boolean isMuted() {
        if (this.muteTime < 0L) {
            return false;
        }
        if (this.muteTime > System.currentTimeMillis()) {
            return true;
        }
        this.muteTime = -1L;
        return false;
    }

    public String getMuteReason() {
        return this.muteReason;
    }

    public void mute(long time, String reason) {
        this.muteTime = System.currentTimeMillis() + time;
        this.muteReason = reason;
        this.getPlayer().sendMessage(Messages.Message.UR_MUTED.get().replace("{REASON}", reason).replace("{TIME}", Utils.getTimeInMaxUnit(time)));
    }

    public void unMute() {
        this.muteTime = -1L;
        this.muteReason = null;
    }

    public long getMuteTime() {
        return this.muteTime;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.getName().equalsIgnoreCase(obj.toString());
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((CGPlayer)obj).getName());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.getName()).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static CGPlayer get(Player p) {
        if (p == null) {
            return null;
        }
        LegacyChatPlayer temp = new LegacyChatPlayer(p);
        if (cache.contains(temp)) {
            CGPlayer player = cache.get(cache.indexOf(temp));
            player.updatePlayer(p);
            return player;
        }
        ChatGuardPlugin.debug(2, cache);
        cache.add(temp);
        return temp;
    }

    public static CGPlayer get(String n) {
        for (CGPlayer cp : cache) {
            if (!cp.getName().equalsIgnoreCase(n)) continue;
            return cp;
        }
        return null;
    }

    public static List<CGPlayer> getCache() {
        return cache;
    }

    public static void clearAllWarnings(Violation v, boolean separate) {
        for (CGPlayer player : cache) {
            player.clearWarnings(v, separate);
        }
    }

    public FixedSizeList<MessagePair> getSentMessages() {
        return this.sentMessages;
    }

    public FixedSizeList<String> getAllMessages() {
        return this.allMessages;
    }

    public int getViolationCount(Violation v, boolean separately) {
        if (!Settings.isSeparatedWarnings() && !separately) {
            return this.violations.size();
        }
        int c = 0;
        for (Violation pv : this.violations) {
            if (v != pv) continue;
            ++c;
        }
        return c;
    }

    public void handleViolation(Violation v, int maxWarn) {
        if (maxWarn == -1) {
            maxWarn = Settings.getMaxWarnCount(v.getPunishmentSection());
        }
        this.violations.add(v);
        int violCount = this.getViolationCount(v, false);
        this.warn(v, violCount, maxWarn);
        if (violCount >= maxWarn && Settings.isPunishmentsEnabled() && Settings.isWarnsEnabled()) {
            this.punish(v);
            this.clearWarnings(v, Settings.isSeparatedWarnings());
        }
    }

    public void clearWarnings(Violation v, boolean separatedWarnings) {
        if (!separatedWarnings || v == null) {
            this.violations.clear();
            return;
        }
        Iterator<Violation> iterator = this.violations.iterator();
        while (iterator.hasNext()) {
            if (v != iterator.next()) continue;
            iterator.remove();
        }
    }

    public void punish(Violation v) {
        for (String command : Settings.getPunishCommands(v.getPunishmentSection())) {
            for (Map.Entry<String, String> reasonEntry : Settings.getPunishReasons().entrySet()) {
                command = command.replace("{Reason_" + reasonEntry.getKey() + "}", reasonEntry.getValue());
            }
            command = command.replace("{Player}", this.getName());
            final StringBuilder sb = new StringBuilder(command);
            ChatGuardPlugin.debug(2, "Punish command: " + command);
            new BukkitRunnable(){

                public void run() {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)sb.toString());
                }
            }.runTask((Plugin)ChatGuardPlugin.getInstance());
        }
    }

    public void warn(Violation v, Integer violCount, Integer max) {
        String warnFormat = Messages.Message.WARN_FORMAT.get().replace("{MAX}", max.toString()).replace("{CURRENT}", violCount.toString());
        if (!Settings.isWarnsEnabled()) {
            warnFormat = "";
        }
        switch (v) {
            case SWEAR: {
                this.getPlayer().sendMessage(Messages.Message.SWEARING.get().replace("{WARNS}", warnFormat));
                break;
            }
            case CAPS: {
                this.getPlayer().sendMessage(Messages.Message.CAPSING.get().replace("{WARNS}", warnFormat));
                break;
            }
            case SPAM: {
                this.getPlayer().sendMessage(Messages.Message.SPAMMING.get().replace("{WARNS}", warnFormat));
                break;
            }
            case FLOOD: {
                this.getPlayer().sendMessage(Messages.Message.FLOODING.get().replace("{WARNS}", warnFormat));
                break;
            }
            default: {
                ChatGuardPlugin.debug(0, "Magic Violation type " + (Object)((Object)v));
            }
        }
    }
}

