/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Integration.AbstractIntegration;
import ru.Den_Abr.ChatGuard.Listeners.PlayerListener;
import ru.Den_Abr.ChatGuard.MessageInfo;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Utils.MessagePair;

public class PacketsListener {
    public static void stopListening() {
        if (ChatPacketListner.instance != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)ChatPacketListner.instance);
        }
    }

    public static void startListening() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new ChatPacketListner((Plugin)ChatGuardPlugin.getInstance(), PacketType.Play.Client.CHAT, PacketType.Play.Server.CHAT));
    }

    public static void sendComponent(Player p, WrappedChatComponent wcc) {
        PacketContainer pc = new PacketContainer(PacketType.Play.Server.CHAT);
        pc.getBytes().writeDefaults();
        pc.getChatComponents().write(0, (Object)wcc);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(p, pc);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static class ChatPacketListner
    extends PacketAdapter {
        static ChatPacketListner instance;

        public ChatPacketListner(Plugin plugin, PacketType ... types) {
            super(plugin, types);
            instance = this;
        }

        public void onPacketReceiving(PacketEvent e) {
            if (AbstractIntegration.shouldSkip(e.getPlayer())) {
                return;
            }
            PacketContainer packet = e.getPacket();
            String message = (String)packet.getStrings().read(0);
            if (!message.startsWith("/") || PlayerListener.getPMCommand(message) != null) {
                message = PlayerListener.substitute(message);
                packet.getStrings().write(0, (Object)message);
                e.setPacket(packet);
            }
            MessageInfo info = null;
            CGPlayer cp = CGPlayer.get(e.getPlayer());
            info = !message.startsWith("/") ? PlayerListener.handleMessage(message, cp) : PlayerListener.handleCommand(message, cp);
            if (info == null) {
                return;
            }
            if (info.isCancelled()) {
                e.setCancelled(true);
            } else {
                cp.getAllMessages().add(ChatColor.stripColor((String)String.valueOf(info.getClearMessage()).toLowerCase()));
            }
            packet.getStrings().write(0, (Object)info.getClearMessage());
            e.setPacket(packet);
        }

        public void onPacketSending(PacketEvent e) {
            if (AbstractIntegration.shouldSkip(e.getPlayer()) || e.getPlayer().hasMetadata("clearing")) {
                return;
            }
            CGPlayer cp = CGPlayer.get(e.getPlayer());
            PacketContainer pc = e.getPacket();
            Object pos = pc.getBytes().readSafely(0);
            String text = null;
            if (pos != null) {
                if ((Byte)pos == 2) {
                    return;
                }
                WrappedChatComponent wcc = (WrappedChatComponent)pc.getChatComponents().readSafely(0);
                if (wcc != null) {
                    Object handle = wcc.getHandle();
                    Method m = null;
                    try {
                        m = handle.getClass().getMethod("c", new Class[0]);
                    }
                    catch (IllegalArgumentException | SecurityException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    catch (NoSuchMethodException e2) {
                        try {
                            m = handle.getClass().getMethod("toPlainText", new Class[0]);
                        }
                        catch (NoSuchMethodException | SecurityException e1) {
                            e1.printStackTrace();
                            return;
                        }
                    }
                    if (m == null) {
                        return;
                    }
                    try {
                        m.setAccessible(true);
                        text = String.valueOf(m.invoke(handle, new Object[0]));
                        cp.getSentMessages().add(new MessagePair(text, wcc.getJson(), false));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                }
            } else {
                text = (String)pc.getStrings().read(0);
                cp.getSentMessages().add(new MessagePair(text, text, true));
            }
        }
    }
}

