/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Configuration;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;

public class Whitelist {
    private static List<Pattern> whitelisted = new ArrayList<Pattern>();
    private static File wlFile;

    public static void load(ChatGuardPlugin pl) {
        wlFile = new File(pl.getDataFolder(), "whitelist.txt");
        if (!wlFile.exists()) {
            pl.saveResource("whitelist.txt", false);
        }
        try {
            for (String line : Files.readLines((File)wlFile, (Charset)StandardCharsets.UTF_8)) {
                if (line.isEmpty()) continue;
                whitelisted.add(Pattern.compile(line, 2));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void add(String s) {
        Pattern p = Pattern.compile(s, 2);
        whitelisted.add(p);
        try {
            Files.append((CharSequence)("\n" + s), (File)wlFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isWhitelisted(String found) {
        for (Pattern p : whitelisted) {
            if (!p.matcher(found).find()) continue;
            return true;
        }
        return false;
    }
}

