/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventPriority;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Utils.Utils;

public class Settings {
    private static final int CONFIG_VERSION = 5;
    private static YamlConfiguration config;
    private static boolean checkUpdates;
    private static boolean usePackets;
    private static boolean separateWarnings;
    private static boolean hardmode;
    private static boolean cancelEnabled;
    private static boolean warnsEnabled;
    private static boolean punishmentsEnabled;
    private static boolean signsEnabled;
    private static boolean itemsEnabled;
    private static int maxWarnings;
    private static int debugLevel;
    private static int cooldown;
    private static long maxMuteTime;
    private static String replacement;
    private static EventPriority prior;
    private static Map<String, Integer> commands;
    private static Map<String, String> reasons;
    private static Map<String, String> substitutions;

    static {
        commands = new HashMap<String, Integer>();
        reasons = new HashMap<String, String>();
        substitutions = new HashMap<String, String>();
    }

    public static void load(ChatGuardPlugin pl) {
        File fconfig = new File(pl.getDataFolder(), "config.yml");
        if (!fconfig.exists()) {
            pl.saveResource("config.yml", false);
        }
        if (!(config = YamlConfiguration.loadConfiguration((File)fconfig)).isSet("Version")) {
            try {
                new File(pl.getDataFolder(), "old").mkdirs();
                com.google.common.io.Files.move((File)fconfig, (File)new File(new File(pl.getDataFolder(), "old"), "old_config.yml"));
                com.google.common.io.Files.move((File)new File(pl.getDataFolder(), "warnings.yml"), (File)new File(new File(pl.getDataFolder(), "old"), "warnings.yml"));
                com.google.common.io.Files.move((File)new File(pl.getDataFolder(), "messages.yml"), (File)new File(new File(pl.getDataFolder(), "old"), "messages.yml"));
                ChatGuardPlugin.getLog().info("Old configuration was moved to old dirrectory");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            fconfig.delete();
            pl.saveResource("config.yml", false);
            config = YamlConfiguration.loadConfiguration((File)fconfig);
        }
        if (config.getInt("Version") != 5) {
            Settings.migrateFrom(config.getInt("Version"));
        }
        checkUpdates = config.getBoolean("Check for updates");
        usePackets = config.getBoolean("Other settings.use packets");
        separateWarnings = config.getBoolean("Warnings settings.separate");
        hardmode = config.getBoolean("Hard mode");
        cancelEnabled = config.getBoolean("Messages.cancel if violation");
        warnsEnabled = config.getBoolean("Warnings settings.enabled");
        punishmentsEnabled = config.getBoolean("Punishment settings.enabled");
        signsEnabled = config.getBoolean("Other settings.check signs");
        itemsEnabled = config.getBoolean("Other settings.check items");
        maxMuteTime = Utils.parseTime(config.getString("Punishment settings.max mute time"));
        replacement = config.getString("Messages.replacement");
        prior = EventPriority.valueOf((String)config.getString("Other settings.event priority").toUpperCase());
        if (prior == null) {
            ChatGuardPlugin.getLog().warning("Wrong priority " + config.getString("Other settings.event priority").toUpperCase() + "! Using HIGHEST");
            prior = EventPriority.HIGHEST;
        }
        maxWarnings = config.getInt("Warnings settings.max count");
        debugLevel = config.getInt("Other settings.debug level");
        cooldown = config.getInt("flood settings.message cooldown");
        commands.clear();
        for (String command : config.getStringList("Other settings.check commands")) {
            String[] cmd = command.split(Pattern.quote(":"));
            if (cmd.length != 2 || !Utils.isInt(cmd[1]) || Integer.parseInt(cmd[1]) < 0) continue;
            commands.put(cmd[0].toLowerCase(), Integer.parseInt(cmd[1]));
        }
        reasons.clear();
        for (String key : config.getConfigurationSection("Punishment settings.reasons").getKeys(false)) {
            reasons.put(key, ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Punishment settings.reasons." + key)));
        }
        substitutions.clear();
        for (String s : config.getStringList("Substitutions")) {
            String[] els = s.split(Pattern.quote("|"), 2);
            if (els.length != 2) continue;
            substitutions.put(els[0], els[1]);
        }
        if (debugLevel > 0) {
            ChatGuardPlugin.debug(1, "Debug level: " + Settings.getDebugLevel());
        }
    }

    public static boolean canCheckUpdates() {
        return checkUpdates;
    }

    public static boolean usePackets() {
        return usePackets;
    }

    public static YamlConfiguration getConfig() {
        return config;
    }

    public static void saveConfig() {
        try {
            Settings.getConfig().save(new File(ChatGuardPlugin.getInstance().getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSeparatedWarnings() {
        return separateWarnings;
    }

    public static int getMaxWarns() {
        return maxWarnings;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static String getReplacement() {
        return replacement;
    }

    public static boolean isHardMode() {
        return hardmode;
    }

    public static boolean isCancellingEnabled() {
        return cancelEnabled || Settings.isHardMode();
    }

    public static int getCooldown() {
        return cooldown;
    }

    public static boolean isCooldownEnabled() {
        return cooldown > 0;
    }

    public static Map<String, Integer> getCheckCommands() {
        return commands;
    }

    public static int getMaxWarnCount(String sec) {
        if (Settings.isSeparatedWarnings()) {
            return config.getInt(String.valueOf(sec) + " settings.max warnings");
        }
        return Settings.getMaxWarns();
    }

    public static List<String> getPunishCommands(String sec) {
        if (!config.getBoolean("Punishment settings.commands.custom")) {
            sec = "common";
        }
        return config.getStringList("Punishment settings.commands." + sec + " commands");
    }

    public static Map<String, String> getPunishReasons() {
        return reasons;
    }

    public static boolean isWarnsEnabled() {
        return warnsEnabled;
    }

    public static boolean isPunishmentsEnabled() {
        return punishmentsEnabled;
    }

    public static boolean isSignsEnabled() {
        return signsEnabled;
    }

    public static long getMaxMuteTime() {
        return maxMuteTime;
    }

    public static boolean isItemsEnabled() {
        return itemsEnabled;
    }

    private static void migrateFrom(int v) {
        if (v == 1) {
            Settings.getConfig().set("Punishment settings.max mute time", (Object)"1h");
            Settings.getConfig().set("Version", (Object)2);
            v = 2;
        }
        if (v == 2 || v == 3) {
            Settings.getConfig().set("Version", (Object)4);
            Settings.getConfig().set("Other settings.check items", (Object)true);
            try {
                Files.write(new File(ChatGuardPlugin.getInstance().getDataFolder(), "ipRegexp.txt").toPath(), Settings.getConfig().getString("spam settings.ip regexp").getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                Files.write(new File(ChatGuardPlugin.getInstance().getDataFolder(), "domainRegexp.txt").toPath(), Settings.getConfig().getString("spam settings.domain regexp").getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                Settings.getConfig().set("spam settings.domain regexp", (Object)"now in domainRegexp.txt");
                Settings.getConfig().set("spam settings.ip regexp", (Object)"now in ipRegexp.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Settings.getConfig().set("Substitutions", Arrays.asList("Red|Green"));
        }
        if (v == 4) {
            Settings.getConfig().set("Version", (Object)5);
            Settings.getConfig().set("Other settings.event priority", (Object)"HIGHEST");
        }
        Settings.saveConfig();
    }

    public static EventPriority getPriority() {
        return prior;
    }

    public static Map<String, String> getSubstitutions() {
        return substitutions;
    }
}

