/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.Commands;

import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import ru.Den_Abr.ChatGuard.ChatFilters.SwearFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Commands.Cmd;
import ru.Den_Abr.ChatGuard.Commands.CommandManager;
import ru.Den_Abr.ChatGuard.Commands.SubCommand;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Configuration.Whitelist;
import ru.Den_Abr.ChatGuard.Listeners.PacketsListener;
import ru.Den_Abr.ChatGuard.Listeners.PlayerListener;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Utils.MessagePair;
import ru.Den_Abr.ChatGuard.Utils.Utils;
import ru.Den_Abr.ChatGuard.Violation;

public class BukkitCommandHandler {
    @Cmd(desc="Show your warnings or (Player)'s", name="info", perm="chatguard.info", args="(Player)")
    public void warnings(CommandSender cs, String[] args) {
        CGPlayer player;
        if (args.length == 0) {
            if (!(cs instanceof Player)) {
                cs.sendMessage("Only players can break the rules!");
                return;
            }
            player = CGPlayer.get((Player)cs);
        } else if (cs.hasPermission("chatguard.info.others")) {
            player = CGPlayer.get(Bukkit.getPlayer((String)args[0]));
        } else {
            cs.sendMessage(Messages.Message.NO_PERMS.get());
            return;
        }
        if (player == null) {
            cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
            return;
        }
        cs.sendMessage(ChatColor.GOLD + player.getName() + ":");
        Violation[] violationArray = Violation.values();
        int n = violationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Violation v = violationArray[n2];
            if (v != Violation.BLACKCHAR) {
                cs.sendMessage(String.valueOf(Messages.Message.valueOf(v.toString().toUpperCase()).get()) + ": " + ChatColor.GRAY + player.getViolationCount(v, true));
            }
            ++n2;
        }
        cs.sendMessage(String.valueOf(Messages.Message.MUTED.get()) + ": " + (Object)((Object)(player.isMuted() ? Messages.Message.YES : Messages.Message.NO)));
        if (player.isMuted()) {
            cs.sendMessage(String.valueOf(Messages.Message.EXPIRE_TIME.get()) + ": " + ChatColor.RED + Utils.getTimeInMaxUnit(player.getMuteTime() - System.currentTimeMillis()));
        }
    }

    @Cmd(desc="Add new banned [WORD]", name="ban", perm="chatguard.banword", args="[WORD]", min=1)
    public void ban(CommandSender cs, String[] args) {
        String word = StringUtils.join((Object[])args, (char)' ').toLowerCase().trim();
        if (SwearFilter.addWord(word)) {
            cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
        } else {
            cs.sendMessage(ChatColor.RED + word + " is already banned");
        }
    }

    @Cmd(desc="Remove banned [WORD]", name="unban", perm="chatguard.unbanword", args="[WORD]", min=1)
    public void unban(CommandSender cs, String[] args) {
        String word = StringUtils.join((Object[])args, (char)' ').toLowerCase().trim();
        if (SwearFilter.removeWord(word)) {
            cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
        } else {
            cs.sendMessage(ChatColor.RED + word + " is not banned");
        }
    }

    @Cmd(desc="Do not mark [WORD] as advertising or swearing", name="whitelist", perm="chatguard.whitelistadd", args="[WORD]", min=1)
    public void whitelist(CommandSender cs, String[] args) {
        String word = StringUtils.join((Object[])args, (char)' ').toLowerCase().trim();
        Whitelist.add(word);
        cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
    }

    @Cmd(desc="Clear your (or everyone's/Player's) chat", name="cc", perm="chatguard.clearchat", args="(ALL|Player)", max=1)
    public void cc(CommandSender cs, String[] args) {
        if (args.length == 0) {
            if (cs instanceof Player) {
                Utils.clearChat((Player)cs);
                CGPlayer.get((Player)cs).getSentMessages().clear();
            } else {
                cs.sendMessage("No.");
            }
            return;
        }
        if (cs.hasPermission("chatguard.clearchat.all") && args[0].equalsIgnoreCase("ALL")) {
            for (Player p : Utils.getOnlinePlayers()) {
                if (p.hasPermission("chatguard.ignore.cc")) continue;
                Utils.clearChat(p);
                CGPlayer.get(p).getSentMessages().clear();
            }
            return;
        }
        if (cs.hasPermission("chatguard.clearchar.others")) {
            Player p = Bukkit.getPlayer((String)args[0]);
            if (p == null || !p.isOnline()) {
                cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
                return;
            }
            Utils.clearChat(p);
            CGPlayer.get(p).getSentMessages().clear();
        } else {
            cs.sendMessage(Messages.Message.NO_PERMS.get());
        }
    }

    @Cmd(desc="Toggle global mute", name="globalmute", perm="chatguard.globalmute", max=0)
    public void globalmute(CommandSender cs, String[] args) {
        PlayerListener.globalMute = !PlayerListener.globalMute;
        Bukkit.broadcastMessage((String)(PlayerListener.globalMute ? Messages.Message.GLOBAL_MUTE_ENABLED.get() : Messages.Message.GLOBAL_MUTE_DISABLED.get()));
    }

    @Cmd(desc="Mute player for some reason", name="mute", perm="chatguard.mute", args="[Player] ([Time] (Reason))", min=1, max=3)
    public void mute(CommandSender cs, String[] args) {
        long parsed;
        Player pl = Bukkit.getPlayer((String)args[0]);
        if (pl == null) {
            cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
            return;
        }
        CGPlayer cp = CGPlayer.get(pl);
        if (cp.isMuted()) {
            cs.sendMessage(Messages.Message.ALREADY_MUTED.get());
            return;
        }
        long time = Settings.getMaxMuteTime();
        if (args.length > 1 && (parsed = Utils.parseTime(args[1])) > 0L && parsed <= Settings.getMaxMuteTime()) {
            time = parsed;
        }
        String reason = Messages.Message.DEFAULT_REASON.get();
        if (args.length > 2) {
            reason = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.join((Object[])Arrays.copyOfRange(args, 2, args.length), (char)' ')).trim();
        }
        cp.mute(time, reason);
        cs.sendMessage(Messages.Message.PLAYER_MUTED.get().replace("{REASON}", reason).replace("{TIME}", Utils.getTimeInMaxUnit(time)));
    }

    @Cmd(desc="Unmute muted player", name="unmute", perm="chatguard.unmute", args="[Player]", min=1, max=1)
    public void unMute(CommandSender cs, String[] args) {
        Player pl = Bukkit.getPlayer((String)args[0]);
        if (pl == null) {
            cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
            return;
        }
        CGPlayer cp = CGPlayer.get(pl);
        if (!cp.isMuted()) {
            cs.sendMessage(Messages.Message.IS_NOT_MUTED.get());
            return;
        }
        cp.unMute();
        cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
    }

    @Cmd(desc="Clear some warnings", name="clear", perm="chatguard.clearwarnings", args="(Type) (Player)", max=2)
    public void clear(CommandSender cs, String[] args) {
        if (args.length > 0) {
            Violation v = Violation.get(args[0].toUpperCase());
            if (!(v != null && v != Violation.BLACKCHAR || args[0].equalsIgnoreCase("ALL"))) {
                StringBuilder sb = new StringBuilder();
                Violation[] violationArray = Violation.values();
                int n = violationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Violation allV = violationArray[n2];
                    if (!allV.getPunishmentSection().equals("none")) {
                        sb.append((Object)allV).append(" ");
                    }
                    ++n2;
                }
                cs.sendMessage(ChatColor.GOLD + "Available types: " + ChatColor.GREEN + sb.toString() + "ALL");
                return;
            }
            if (args.length == 1) {
                CGPlayer.clearAllWarnings(v, true);
            } else if (args.length == 2) {
                CGPlayer p = CGPlayer.get(args[1]);
                if (p == null) {
                    cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
                    return;
                }
                p.clearWarnings(args[0].equalsIgnoreCase("ALL") ? null : v, true);
            }
        } else {
            CGPlayer.clearAllWarnings(null, false);
        }
        cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
    }

    @Cmd(desc="Clear messages of specified player", name="of", perm="chatguard.clearof", min=1)
    public void of(CommandSender cs, String[] args) {
        if (!Settings.usePackets()) {
            cs.sendMessage(ChatColor.RED + "Enable 'use packets' settings first.");
            return;
        }
        CGPlayer cp = CGPlayer.get(args[0]);
        if (cp == null) {
            cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
            return;
        }
        for (Player p : Utils.getOnlinePlayers()) {
            p.setMetadata("clearing", (MetadataValue)new FixedMetadataValue((Plugin)ChatGuardPlugin.getInstance(), (Object)true));
            CGPlayer clp = CGPlayer.get(p);
            Utils.clearChat(p);
            block1: for (MessagePair mp : clp.getSentMessages()) {
                for (String am : cp.getAllMessages()) {
                    if (mp.getKey().toLowerCase().contains(am)) continue block1;
                }
                if (!mp.isOld()) {
                    PacketsListener.sendComponent(p, WrappedChatComponent.fromJson((String)mp.getValue()));
                    continue;
                }
                p.sendMessage(mp.getValue());
            }
            p.removeMetadata("clearing", (Plugin)ChatGuardPlugin.getInstance());
        }
    }

    @Cmd(desc="Warn [Player]", name="warn", perm="chatguard.warn", args="[Player] [Type]", min=2, max=2)
    public void warn(CommandSender cs, String[] args) {
        Player p = Bukkit.getPlayer((String)args[0]);
        if (p == null || !p.isOnline()) {
            cs.sendMessage(Messages.Message.PLAYER_NOT_FOUND.get());
            return;
        }
        String type = args[1].toUpperCase();
        Violation v = Violation.get(type);
        if (v == null || v == Violation.BLACKCHAR) {
            StringBuilder sb = new StringBuilder();
            Violation[] violationArray = Violation.values();
            int n = violationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Violation allV = violationArray[n2];
                if (!allV.getPunishmentSection().equals("none")) {
                    sb.append((Object)allV).append(" ");
                }
                ++n2;
            }
            cs.sendMessage(ChatColor.GOLD + "Available types: " + ChatColor.GREEN + sb.toString().trim());
            return;
        }
        CGPlayer cgp = CGPlayer.get(p);
        cgp.handleViolation(v, -1);
        cs.sendMessage(Messages.Message.SUCCESSFULLY.get());
    }

    @Cmd(desc="Reload plugin configurations", name="reload", perm="chatguard.reload", max=0)
    public void reload(CommandSender cs, String[] args) {
        Settings.load(ChatGuardPlugin.getInstance());
        Messages.load(ChatGuardPlugin.getInstance());
        Whitelist.load(ChatGuardPlugin.getInstance());
        ChatGuardPlugin.getInstance().registerFilters();
        cs.sendMessage(ChatColor.GRAY + "Reload complete.");
    }

    @Cmd(desc="Show this page", name="help", perm="")
    public void help(CommandSender cs, String[] args) {
        cs.sendMessage(ChatColor.GOLD + ChatGuardPlugin.getInstance().getDescription().getName() + " v" + ChatColor.GREEN + ChatGuardPlugin.getInstance().getDescription().getVersion() + ChatColor.GOLD + " by " + ChatColor.DARK_PURPLE + (String)ChatGuardPlugin.getInstance().getDescription().getAuthors().get(0));
        for (SubCommand sc : CommandManager.instance.subComs.getCommands()) {
            if (!sc.isPermitted(cs)) continue;
            sc.printHelp(cs, "chatguard");
        }
    }
}

