/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard;

import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatFilters.CapsFilter;
import ru.Den_Abr.ChatGuard.ChatFilters.CharacterFilter;
import ru.Den_Abr.ChatGuard.ChatFilters.FloodFilter;
import ru.Den_Abr.ChatGuard.ChatFilters.SpamFilter;
import ru.Den_Abr.ChatGuard.ChatFilters.SwearFilter;
import ru.Den_Abr.ChatGuard.Commands.CommandManager;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Configuration.Whitelist;
import ru.Den_Abr.ChatGuard.Integration.AbstractIntegration;
import ru.Den_Abr.ChatGuard.Integration.AuthMe34;
import ru.Den_Abr.ChatGuard.Integration.AuthMe5;
import ru.Den_Abr.ChatGuard.Integration.AuthMeLegacy;
import ru.Den_Abr.ChatGuard.Listeners.ItemListener;
import ru.Den_Abr.ChatGuard.Listeners.PacketsListener;
import ru.Den_Abr.ChatGuard.Listeners.PlayerListener;
import ru.Den_Abr.ChatGuard.Listeners.SignListener;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Utils.Utils;
import thirdparty.net.gravitydevelopment.updater.Updater;
import thirdparty.org.mcstats.Metrics;

public class ChatGuardPlugin
extends JavaPlugin {
    private static ChatGuardPlugin instance;
    public static Metrics metrics;

    public void onEnable() {
        instance = this;
        this.getCommand("cg").setExecutor((CommandExecutor)new CommandManager(this));
        Settings.load(this);
        if (Settings.canCheckUpdates()) {
            this.checkForUpdates();
        }
        Messages.load(this);
        Whitelist.load(this);
        ItemListener.scheduleChecks();
        this.initMetrics();
        if (!this.setupProtocol()) {
            final PlayerListener listener = new PlayerListener();
            EventExecutor exec = new EventExecutor(){

                public void execute(Listener paramListener, Event e) throws EventException {
                    if (e instanceof AsyncPlayerChatEvent) {
                        listener.onPlayerChat((AsyncPlayerChatEvent)e);
                    }
                    if (e instanceof PlayerCommandPreprocessEvent) {
                        listener.onPlayerCommand((PlayerCommandPreprocessEvent)e);
                    }
                }
            };
            this.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)listener, Settings.getPriority(), exec, (Plugin)this, true);
            this.getServer().getPluginManager().registerEvent(PlayerCommandPreprocessEvent.class, (Listener)listener, Settings.getPriority(), exec, (Plugin)this, true);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SignListener(), (Plugin)this);
        this.registerIntegratedPlugins();
        this.registerFilters();
        this.loadOnlinePlayers();
        this.startMetrics();
        this.getLogger().info("ChatGuard enabled!");
    }

    private void loadOnlinePlayers() {
        for (Player p : Utils.getOnlinePlayers()) {
            CGPlayer.get(p);
        }
    }

    private void registerIntegratedPlugins() {
        AbstractIntegration.getIntegratedPlugins().clear();
        new AuthMeLegacy().register();
        new AuthMe34().register();
        new AuthMe5().register();
    }

    public void registerFilters() {
        AbstractFilter.getActiveFilters().clear();
        new CharacterFilter().register();
        new FloodFilter().register();
        new CapsFilter().register();
        new SpamFilter().register();
        new SwearFilter().register();
    }

    private void initMetrics() {
        try {
            metrics = new Metrics((Plugin)this);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to init metrics");
        }
    }

    private void startMetrics() {
        if (metrics != null) {
            metrics.start();
        }
    }

    private void checkForUpdates() {
        new Updater((Plugin)this, 50092, this.getFile(), Updater.UpdateType.DEFAULT, true);
    }

    public static ChatGuardPlugin getInstance() {
        return instance;
    }

    private boolean setupProtocol() {
        if (!Settings.usePackets()) {
            return false;
        }
        Plugin plpl = this.getServer().getPluginManager().getPlugin("ProtocolLib");
        if (plpl != null && plpl.isEnabled()) {
            this.getLogger().info("ProtocolLib found!");
            PacketsListener.startListening();
            return true;
        }
        this.getLogger().info("Install ProtocolLib to enable 'use packets' setting");
        return false;
    }

    public void onDisable() {
        if (Settings.usePackets()) {
            PacketsListener.stopListening();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public static void debug(int level, Object ... o) {
        if (level > Settings.getDebugLevel()) {
            return;
        }
        Object[] objectArray = o;
        int n = o.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ChatGuardPlugin.getInstance().getLogger().info("[DEBUG " + level + "] " + obj);
            ++n2;
        }
    }

    public static Logger getLog() {
        return ChatGuardPlugin.getInstance().getLogger();
    }
}

