/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.ChatFilters;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Configuration.Whitelist;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Utils.Utils;
import ru.Den_Abr.ChatGuard.Violation;
import thirdparty.org.mcstats.Metrics;

public class SwearFilter
extends AbstractFilter {
    private static Pattern swearPattern;
    private String replacement;
    private boolean informAdmins;

    @Override
    public Violation checkMessage(String message, CGPlayer player, boolean justCheck) {
        if (player.hasPermission("chatguard.ignore.swear")) {
            return null;
        }
        ChatGuardPlugin.debug(2, String.valueOf(this.getClass().getSimpleName()) + ": Hello!");
        String checkMessage = message;
        if (Settings.isHardMode()) {
            checkMessage = checkMessage.replaceAll(" ", "").replaceAll("[^A-Za-z\u0410-\u042f\u0430-\u044f\u00e0-\u00ff\u00c0-\u00df]", "");
        }
        Violation v = null;
        Matcher swearMatcher = swearPattern.matcher(checkMessage.toLowerCase());
        ArrayList<String> matches = new ArrayList<String>();
        while (swearMatcher.find()) {
            if (swearMatcher.group().trim().isEmpty()) continue;
            String found = Utils.getWord(message, swearMatcher.start(), swearMatcher.end());
            ChatGuardPlugin.debug(1, String.valueOf(this.getClass().getSimpleName()) + " found: " + swearMatcher.group());
            if (Whitelist.isWhitelisted(found.toLowerCase())) {
                ChatGuardPlugin.debug(2, String.valueOf(this.getClass().getSimpleName()) + ": " + found + " is whitelisted");
                continue;
            }
            matches.add(found);
            v = Violation.SWEAR;
        }
        if (Settings.isHardMode()) {
            matches.clear();
        }
        if (!justCheck && v != null && this.informAdmins) {
            this.informAdmins(player, message, matches);
        }
        return v;
    }

    @Override
    public Violation checkMessage(String message, CGPlayer player) {
        return this.checkMessage(message, player, false);
    }

    private void informAdmins(CGPlayer player, String message, List<String> matches) {
        String complete = Messages.Message.INFORM_SWEAR.get().replace("{PLAYER}", player.getName()).replace("{MESSAGE}", ChatColor.stripColor((String)message));
        for (String s : matches) {
            complete = Utils.replaceFirstSafely(complete, s, ChatColor.UNDERLINE + s + ChatColor.RESET);
        }
        Bukkit.getConsoleSender().sendMessage(complete);
        Bukkit.broadcast((String)complete, (String)"chatguard.inform.swear");
    }

    @Override
    public String getClearMessage(String message, CGPlayer player) {
        if (player.hasPermission("chatguard.ignore.swear")) {
            return message;
        }
        Matcher swearMatcher = swearPattern.matcher(message.toLowerCase());
        ArrayList<String> toReplace = new ArrayList<String>();
        while (swearMatcher.find()) {
            String found;
            if (swearMatcher.group().trim().isEmpty() || Whitelist.isWhitelisted((found = Utils.getWord(message, swearMatcher.start(), swearMatcher.end())).toLowerCase())) continue;
            toReplace.add(found);
        }
        for (String s : toReplace) {
            message = Utils.replaceFirstSafely(message, s, Settings.isSeparatedWarnings() ? this.replacement : Settings.getReplacement());
        }
        return message;
    }

    private static void loadWords() throws IOException {
        File oldFileSwear = new File(ChatGuardPlugin.getInstance().getDataFolder(), "swearlist.txt");
        File newFileSwear = new File(ChatGuardPlugin.getInstance().getDataFolder(), "swearwords.txt");
        if (!newFileSwear.exists()) {
            if (oldFileSwear.exists()) {
                String oldLine = Files.readFirstLine((File)oldFileSwear, (Charset)Charset.forName("UTF-8")).replace('|', '\n');
                Files.write((byte[])oldLine.getBytes(Charset.forName("UTF-8")), (File)newFileSwear);
                new File(ChatGuardPlugin.getInstance().getDataFolder(), "old").mkdirs();
                Files.move((File)oldFileSwear, (File)new File(ChatGuardPlugin.getInstance().getDataFolder(), "old" + File.separator + "swearlist.txt"));
                ChatGuardPlugin.getLog().info("Moved old swearlist file");
            } else {
                ChatGuardPlugin.getInstance().saveResource("swearwords.txt", false);
                ChatGuardPlugin.getInstance().getLogger().warning("Check your swearwords.txt file!");
            }
        }
        String pat = "";
        for (String word : new ArrayList(Files.readLines((File)newFileSwear, (Charset)Charset.forName("UTF-8")))) {
            if (word.isEmpty()) continue;
            pat = pat.isEmpty() ? word : String.valueOf(pat) + "|" + word;
        }
        swearPattern = Pattern.compile(pat, 2);
    }

    @Override
    public void register() {
        ConfigurationSection cs = Settings.getConfig().getConfigurationSection("swear settings");
        if (!cs.getBoolean("enabled")) {
            return;
        }
        this.informAdmins = cs.getBoolean("inform admins");
        this.maxWarns = cs.getInt("max warnings");
        this.replacement = ChatColor.translateAlternateColorCodes((char)'&', (String)cs.getString("custom replacement"));
        try {
            SwearFilter.loadWords();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.addMetricsGraph();
        SwearFilter.getActiveFilters().add(this);
    }

    public static boolean addWord(String w) {
        Pattern p = Pattern.compile(w);
        if (swearPattern.pattern().contains(p.pattern())) {
            return false;
        }
        File swearFile = new File(ChatGuardPlugin.getInstance().getDataFolder(), "swearwords.txt");
        try {
            Files.append((CharSequence)("\n" + w), (File)swearFile, (Charset)StandardCharsets.UTF_8);
            SwearFilter.loadWords();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean removeWord(String w) {
        Pattern p = Pattern.compile(w);
        if (!swearPattern.pattern().contains(p.pattern())) {
            return false;
        }
        File swearFile = new File(ChatGuardPlugin.getInstance().getDataFolder(), "swearwords.txt");
        try {
            ArrayList<String> temp = new ArrayList<String>();
            for (String line : Files.readLines((File)swearFile, (Charset)StandardCharsets.UTF_8)) {
                if (line.equalsIgnoreCase(w)) continue;
                temp.add(line);
            }
            String toWrite = StringUtils.join(temp, (String)"\n");
            Files.write((byte[])toWrite.getBytes(StandardCharsets.UTF_8), (File)swearFile);
            SwearFilter.loadWords();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void addMetricsGraph() {
        Metrics.Graph g = ChatGuardPlugin.metrics.getOrCreateGraph("Filters used");
        g.addPlotter(new Metrics.Plotter("Swear filter"){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }
}

