/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.ChatFilters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Configuration.Whitelist;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Utils.Utils;
import ru.Den_Abr.ChatGuard.Violation;
import thirdparty.org.mcstats.Metrics;

public class SpamFilter
extends AbstractFilter {
    private Pattern ipPattern;
    private Pattern domainPattern;
    private String replacement;
    private boolean informAdmins;
    private int maxNums;

    @Override
    public Violation checkMessage(String message, CGPlayer player, boolean justCheck) {
        String found;
        if (player.hasPermission("chatguard.ignore.spam")) {
            return null;
        }
        ChatGuardPlugin.debug(2, String.valueOf(this.getClass().getSimpleName()) + ": Hello!");
        String checkMessage = message;
        if (Settings.isHardMode()) {
            checkMessage = checkMessage.replace(" ", "");
        }
        Matcher ipMatcher = this.ipPattern.matcher(checkMessage);
        Matcher domMatcher = this.domainPattern.matcher(checkMessage);
        Violation v = null;
        ArrayList<String> matches = new ArrayList<String>();
        while (ipMatcher.find()) {
            found = ipMatcher.group();
            if (Whitelist.isWhitelisted(found)) continue;
            matches.add(found);
            v = Violation.SPAM;
        }
        while (domMatcher.find()) {
            found = domMatcher.group();
            if (Whitelist.isWhitelisted(found)) continue;
            matches.add(found);
            v = Violation.SPAM;
        }
        if (this.maxNums > 0) {
            int numCount = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)).replaceAll("[^0-9]", "").length();
            ChatGuardPlugin.debug(1, "Numbers count: " + numCount);
            if (numCount > this.maxNums) {
                v = Violation.SPAM;
            }
        }
        if (Settings.isHardMode()) {
            matches.clear();
        }
        if (!justCheck && v != null && this.informAdmins) {
            this.informAdmins(player, message, matches);
        }
        return v;
    }

    @Override
    public Violation checkMessage(String message, CGPlayer player) {
        return this.checkMessage(message, player, false);
    }

    private void informAdmins(CGPlayer player, String message, List<String> matches) {
        String complete = Messages.Message.INFORM_SPAM.get().replace("{PLAYER}", player.getName()).replace("{MESSAGE}", ChatColor.stripColor((String)message));
        for (String s : matches) {
            complete = Utils.replaceFirstSafely(complete, s, ChatColor.UNDERLINE + s + ChatColor.RESET);
        }
        Bukkit.getConsoleSender().sendMessage(complete);
        Bukkit.broadcast((String)complete, (String)"chatguard.inform.spam");
    }

    @Override
    public String getClearMessage(String message, CGPlayer player) {
        if (player.hasPermission("chatguard.ignore.spam")) {
            return message;
        }
        Matcher ipMatcher = this.ipPattern.matcher(message);
        Matcher domMatcher = this.domainPattern.matcher(message);
        while (ipMatcher.find()) {
            String group = ipMatcher.group();
            if (Whitelist.isWhitelisted(group)) continue;
            message = message.replace(group, Settings.isSeparatedWarnings() ? this.replacement : Settings.getReplacement());
        }
        while (domMatcher.find()) {
            String found = Utils.getWord(message, domMatcher.start(), domMatcher.end());
            if (Whitelist.isWhitelisted(found)) continue;
            message = message.replace(found, Settings.isSeparatedWarnings() ? this.replacement : Settings.getReplacement());
        }
        if (this.maxNums > 0) {
            StringBuffer sb = new StringBuffer();
            int charCount = 0;
            int i = 0;
            while (i < message.length()) {
                if (!Character.isDigit(message.charAt(i)) || ++charCount <= this.maxNums) {
                    sb.append(message.charAt(i));
                }
                ++i;
            }
            return sb.toString().trim();
        }
        return message;
    }

    @Override
    public void register() {
        ConfigurationSection cs = Settings.getConfig().getConfigurationSection("spam settings");
        if (!cs.getBoolean("enabled")) {
            return;
        }
        this.informAdmins = cs.getBoolean("inform admins");
        this.maxWarns = cs.getInt("max warnings");
        File ipFile = new File(ChatGuardPlugin.getInstance().getDataFolder(), "ipRegexp.txt");
        File domFile = new File(ChatGuardPlugin.getInstance().getDataFolder(), "domainRegexp.txt");
        if (!ipFile.exists()) {
            ChatGuardPlugin.getInstance().saveResource(ipFile.getName(), false);
        }
        if (!domFile.exists()) {
            ChatGuardPlugin.getInstance().saveResource(domFile.getName(), false);
        }
        this.ipPattern = Pattern.compile(Utils.readLine(ipFile), 2);
        this.domainPattern = Pattern.compile(Utils.readLine(domFile), 2);
        this.maxNums = cs.getInt("max numbers");
        this.replacement = ChatColor.translateAlternateColorCodes((char)'&', (String)cs.getString("custom replacement"));
        this.addMetricsGraph();
        SpamFilter.getActiveFilters().add(this);
    }

    @Override
    public void addMetricsGraph() {
        Metrics.Graph g = ChatGuardPlugin.metrics.getOrCreateGraph("Filters used");
        g.addPlotter(new Metrics.Plotter("Spam filter"){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }
}

