/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.ChatFilters;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Violation;
import thirdparty.org.mcstats.Metrics;

public class FloodFilter
extends AbstractFilter {
    private boolean informAdmins;
    private int floodTime;
    private int levels;

    @Override
    public Violation checkMessage(String message, CGPlayer player, boolean justCheck) {
        Violation v = null;
        if (player.hasPermission("chatguard.ignore.flood")) {
            return v;
        }
        ChatGuardPlugin.debug(2, String.valueOf(this.getClass().getSimpleName()) + ": " + message);
        if (player.getLastMessages().getFixedSize() != this.levels) {
            player.getLastMessages().setFixedSize(this.levels);
            return v;
        }
        if (player.getLastMessages().isEmpty() || player.getLastMessageTime() == -1L || player.getLastMessageTime() + TimeUnit.SECONDS.toMillis(this.floodTime) < System.currentTimeMillis()) {
            return v;
        }
        String wws = message.replaceAll("\\s+", " ").toLowerCase();
        ChatGuardPlugin.debug(2, "Message without whitespaces: " + wws);
        for (String lm : player.getLastMessages()) {
            lm = lm.replaceAll("\\s+", " ").toLowerCase();
            ChatGuardPlugin.debug(2, "Last message: " + lm);
            if (!lm.equalsIgnoreCase(wws) && (!lm.startsWith(wws) || wws.length() - lm.length() >= 4)) continue;
            v = Violation.FLOOD;
        }
        if (!justCheck && v != null && this.informAdmins) {
            this.informAdmins(player, message);
        }
        return v;
    }

    @Override
    public Violation checkMessage(String message, CGPlayer player) {
        return this.checkMessage(message, player, false);
    }

    private void informAdmins(CGPlayer player, String message) {
        String complete = Messages.Message.INFORM_FLOOD.get().replace("{PLAYER}", player.getName()).replace("{MESSAGE}", message);
        Bukkit.getConsoleSender().sendMessage(complete);
        Bukkit.broadcast((String)complete, (String)"chatguard.inform.flood");
    }

    @Override
    public String getClearMessage(String message, CGPlayer player) {
        return message;
    }

    @Override
    public void register() {
        ConfigurationSection cs = Settings.getConfig().getConfigurationSection("flood settings");
        if (!cs.getBoolean("enabled")) {
            return;
        }
        this.informAdmins = cs.getBoolean("inform admins");
        this.maxWarns = cs.getInt("max warnings");
        this.floodTime = cs.getInt("flood time");
        this.levels = cs.getInt("flood levels");
        this.addMetricsGraph();
        FloodFilter.getActiveFilters().add(this);
    }

    @Override
    public void addMetricsGraph() {
        Metrics.Graph g = ChatGuardPlugin.metrics.getOrCreateGraph("Filters used");
        g.addPlotter(new Metrics.Plotter("Flood filter"){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }
}

