/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.ChatFilters;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Violation;
import thirdparty.org.mcstats.Metrics;

public class CharacterFilter
extends AbstractFilter {
    private String charSet;

    @Override
    public Violation checkMessage(String message, CGPlayer player, boolean justCheck) {
        if (player.hasPermission("chatguard.ignore.characters")) {
            return null;
        }
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.isNotAllowed(c)) {
                return Violation.BLACKCHAR;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Violation checkMessage(String message, CGPlayer player) {
        return this.checkMessage(message, player, false);
    }

    @Override
    public String getClearMessage(String message, CGPlayer player) {
        if (player.hasPermission("chatguard.ignore.characters")) {
            return message;
        }
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.isNotAllowed(c)) {
                message = message.replace(Character.valueOf(c).toString(), "");
            }
            ++n2;
        }
        return message;
    }

    private boolean isNotAllowed(char ch) {
        return !this.charSet.contains(String.valueOf(ch));
    }

    @Override
    public void register() {
        if (!Settings.getConfig().getBoolean("Messages.enable character whitelist")) {
            return;
        }
        try {
            File fCh = new File(ChatGuardPlugin.getInstance().getDataFolder(), "characterwhitelist.txt");
            File oldFCh = new File(ChatGuardPlugin.getInstance().getDataFolder(), "allowedsymbols.txt");
            if (!fCh.exists()) {
                if (oldFCh.exists()) {
                    Files.move((File)oldFCh, (File)fCh);
                } else {
                    ChatGuardPlugin.getInstance().saveResource("characterwhitelist.txt", false);
                }
            }
            this.charSet = Files.readFirstLine((File)fCh, (Charset)Charset.forName("UTF-8"));
            this.addMetricsGraph();
            CharacterFilter.getActiveFilters().add(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addMetricsGraph() {
        Metrics.Graph g = ChatGuardPlugin.metrics.getOrCreateGraph("Filters used");
        g.addPlotter(new Metrics.Plotter("Character filter"){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }
}

