/*
 * Decompiled with CFR 0.152.
 */
package ru.Den_Abr.ChatGuard.ChatFilters;

import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import ru.Den_Abr.ChatGuard.ChatFilters.AbstractFilter;
import ru.Den_Abr.ChatGuard.ChatGuardPlugin;
import ru.Den_Abr.ChatGuard.Configuration.Messages;
import ru.Den_Abr.ChatGuard.Configuration.Settings;
import ru.Den_Abr.ChatGuard.Player.CGPlayer;
import ru.Den_Abr.ChatGuard.Violation;
import thirdparty.org.mcstats.Metrics;

public class CapsFilter
extends AbstractFilter {
    private boolean informAdmins;
    private int maxCapsPercent;
    private int minLenght;

    @Override
    public Violation checkMessage(String message, CGPlayer player, boolean justCheck) {
        Violation v;
        if (message.length() < this.minLenght) {
            return null;
        }
        if (player.hasPermission("chatguard.ignore.caps")) {
            return null;
        }
        ChatGuardPlugin.debug(2, String.valueOf(this.getClass().getSimpleName()) + ": Hello!");
        String ws = message.replaceAll(" ", "").replaceAll("[^A-Za-z\u0410-\u042f\u0430-\u044f\u00e0-\u00ff\u00c0-\u00df]", "");
        if (ws.length() == 0 || ws.length() < this.minLenght) {
            return null;
        }
        int capsCount = this.getCapsCount(ws);
        int capspercent = capsCount * 100 / ws.length();
        Violation violation = v = capspercent > this.maxCapsPercent ? Violation.CAPS : null;
        if (!justCheck && v != null && this.informAdmins) {
            this.informAdmins(player, message);
        }
        return v;
    }

    @Override
    public Violation checkMessage(String message, CGPlayer player) {
        return this.checkMessage(message, player, false);
    }

    private void informAdmins(CGPlayer player, String message) {
        String complete = Messages.Message.INFORM_CAPS.get().replace("{PLAYER}", player.getName()).replace("{MESSAGE}", message);
        Bukkit.getConsoleSender().sendMessage(complete);
        Bukkit.broadcast((String)complete, (String)"chatguard.inform.caps");
    }

    private int getCapsCount(String message) {
        int count = 0;
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isUpperCase(ch)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public String getClearMessage(String message, CGPlayer player) {
        if (player.hasPermission("chatguard.ignore.caps")) {
            return message;
        }
        return message.toLowerCase();
    }

    @Override
    public void register() {
        ConfigurationSection cs = Settings.getConfig().getConfigurationSection("caps settings");
        if (!cs.getBoolean("enabled")) {
            return;
        }
        this.informAdmins = cs.getBoolean("inform admins");
        this.maxWarns = cs.getInt("max warnings");
        this.maxCapsPercent = cs.getInt("max caps percent");
        this.minLenght = cs.getInt("min message lenght");
        this.addMetricsGraph();
        CapsFilter.getActiveFilters().add(this);
    }

    @Override
    public void addMetricsGraph() {
        Metrics.Graph g = ChatGuardPlugin.metrics.getOrCreateGraph("Filters used");
        g.addPlotter(new Metrics.Plotter("Caps filter"){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }
}

