/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.Util;

import com.ktar5.infoboard.InfoBoard;
import java.util.List;

public class Settings {
    public static boolean doesGlobalHaveScoreBoard(int rotation) {
        boolean hasBoard = false;
        for (String s : InfoBoard.getFileManager().getBoard().getConfigurationSection("Info Board." + String.valueOf(rotation)).getKeys(true)) {
            if (s.contains(".") || !s.equals("global")) continue;
            hasBoard = true;
            break;
        }
        return hasBoard;
    }

    public static boolean doesRankHaveScoreBoard(int rotation, String world, String rank) {
        boolean hasBoard = false;
        for (String s : InfoBoard.getFileManager().getBoard().getConfigurationSection("Info Board." + String.valueOf(rotation) + "." + world).getKeys(true)) {
            if (s.contains(".") || !s.equals(rank)) continue;
            hasBoard = true;
            break;
        }
        return hasBoard;
    }

    public static boolean doesWorldHaveScoreBoard(int rotation, String world) {
        boolean hasBoard = false;
        for (String s : InfoBoard.getFileManager().getBoard().getConfigurationSection("Info Board." + String.valueOf(rotation)).getKeys(true)) {
            if (s.contains(".") || !s.equalsIgnoreCase(world)) continue;
            hasBoard = true;
            break;
        }
        return hasBoard;
    }

    public static List<String> getRegionsDisabled() {
        return InfoBoard.getFileManager().getConfig().getStringList("WorldGuard.Prevent Showing In");
    }

    public static boolean isWorldDisabled(String world) {
        if (InfoBoard.getFileManager().getConfig() == null) {
            return false;
        }
        return InfoBoard.getFileManager().getConfig().getStringList("Disabled Worlds").contains(world) || world == null;
    }

    public static boolean scrollingEnabled() {
        return InfoBoard.getFileManager().getConfig().getBoolean("Scrolling Text.Enable");
    }
}

