/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.Util;

import com.ktar5.infoboard.InfoBoard;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    private YamlConfiguration variable;
    private File boardFile;
    private File variableFile;
    private YamlConfiguration board;

    public FileManager() {
        this.getVariables().options().copyDefaults(true);
        this.saveVariables();
        this.getBoard().options().copyDefaults(true);
        this.saveBoard();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public FileConfiguration getBoard() {
        if (this.board == null) {
            this.reloadBoard();
            this.saveBoard();
        }
        return this.board;
    }

    public FileConfiguration getConfig() throws NullPointerException {
        if (InfoBoard.instance == null) {
            throw new NullPointerException("Something went wrong in InfoBoard");
        }
        return InfoBoard.instance.getConfig();
    }

    public FileConfiguration getVariables() {
        if (this.variable == null) {
            this.reloadVariables();
            this.saveVariables();
        }
        return this.variable;
    }

    public void reloadBoard() {
        if (this.boardFile == null) {
            this.boardFile = new File(Bukkit.getPluginManager().getPlugin("InfoBoardReborn").getDataFolder(), "Board.yml");
        }
        this.board = YamlConfiguration.loadConfiguration((File)this.boardFile);
        InputStream defConfigStream = Bukkit.getPluginManager().getPlugin("InfoBoardReborn").getResource("Board.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            if (!this.boardFile.exists() || this.boardFile.length() == 0L) {
                this.board.setDefaults((Configuration)defConfig);
            }
        }
    }

    public void reloadConfig() {
        InfoBoard.instance.reloadConfig();
    }

    public void reloadVariables() {
        if (this.variableFile == null) {
            this.variableFile = new File(Bukkit.getPluginManager().getPlugin("InfoBoardReborn").getDataFolder(), "Variables.yml");
        }
        this.variable = YamlConfiguration.loadConfiguration((File)this.variableFile);
        InputStream defConfigStream = Bukkit.getPluginManager().getPlugin("InfoBoardReborn").getResource("Variables.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.variable.setDefaults((Configuration)defConfig);
        }
    }

    public void saveBoard() {
        if (this.board == null || this.boardFile == null) {
            return;
        }
        try {
            this.getBoard().save(this.boardFile);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save config " + this.boardFile, ex);
        }
    }

    public void saveConfig() {
        InfoBoard.instance.saveConfig();
    }

    public void saveVariables() {
        if (this.variable == null || this.variableFile == null) {
            return;
        }
        try {
            this.getVariables().save(this.variableFile);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save config " + this.variableFile, ex);
        }
    }
}

