/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.Scoreboard;

import com.ktar5.infoboard.API.Vault;
import com.ktar5.infoboard.API.WorldGuard;
import com.ktar5.infoboard.InfoBoard;
import com.ktar5.infoboard.Scoreboard.Board;
import com.ktar5.infoboard.Scoreboard.ShouldSet;
import com.ktar5.infoboard.Scroll.Scroll;
import com.ktar5.infoboard.Scroll.ScrollManager;
import com.ktar5.infoboard.Util.Messages;
import com.ktar5.infoboard.Util.Settings;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

public class Create {
    public static boolean createScoreBoard(Player player) {
        String worldName = "global";
        String rankName = "default";
        int spaces = 0;
        if (WorldGuard.boardsAllowedHere(player.getLocation()) && !Settings.isWorldDisabled(player.getWorld().getName()) && player.hasPermission("InfoBoard.View") && !InfoBoard.hidefrom.contains(player.getName()) && (player.getScoreboard().getObjective(DisplaySlot.SIDEBAR) == null || player.getScoreboard().getObjective(DisplaySlot.SIDEBAR).getName().equalsIgnoreCase("InfoBoard"))) {
            if (Settings.doesWorldHaveScoreBoard(InfoBoard.getTimers().getPage(), player.getWorld().getName())) {
                worldName = player.getWorld().getName();
            } else if (Settings.doesGlobalHaveScoreBoard(InfoBoard.getTimers().getPage())) {
                worldName = "global";
            } else {
                return false;
            }
            String rank = Vault.getRank(player);
            if (Settings.doesRankHaveScoreBoard(InfoBoard.getTimers().getPage(), worldName, rank)) {
                rankName = rank;
            }
            if (!Settings.doesRankHaveScoreBoard(InfoBoard.getTimers().getPage(), worldName, rankName)) {
                return false;
            }
            if (player.getScoreboard().getObjective(DisplaySlot.SIDEBAR) != null) {
                player.getScoreboard().getObjective(DisplaySlot.SIDEBAR).unregister();
                player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
            }
            Board board = new Board();
            ScrollManager.reset(player);
            board.setTitle(Messages.getTitle(player, worldName, rankName));
            List lines = InfoBoard.getFileManager().getBoard().getStringList("Info Board." + String.valueOf(InfoBoard.getTimers().getPage()) + "." + worldName + "." + rankName + ".Rows");
            int row = 0;
            while (row != lines.size()) {
                String line = (String)lines.get(row);
                ShouldSet set = new ShouldSet(player, line);
                line = set.getLine();
                if (set.getBoolean()) {
                    if (line.equals(" ") || line.equals("")) {
                        String space = "\u00a7" + spaces;
                        ++spaces;
                        board.add(Messages.getColored(space), row);
                    } else if (line.startsWith("<scroll>")) {
                        if (Settings.scrollingEnabled()) {
                            line = line.replaceAll("<scroll>", "");
                            int longestLine = Create.getLongestLine(lines, player);
                            String string = Messages.getLine(line, player);
                            Scroll sc = ScrollManager.createScroller(player, string, -row, longestLine);
                            line = sc.getMessage();
                            board.add(line, row);
                        } else {
                            line = "Enable Scroll";
                            board.add(line, row);
                        }
                    } else if (line.contains(";")) {
                        String a = line.split(";")[0];
                        String b = line.split(";")[1];
                        try {
                            board.add(Messages.getLine(a, player), Integer.valueOf(Messages.getLine(b, player)));
                        }
                        catch (NumberFormatException ne) {
                            board.add(Messages.getLine(a, player), 0);
                        }
                    } else {
                        board.add(Messages.getLine(line, player), row);
                    }
                }
                ++row;
            }
            player.setScoreboard(board.getScoreboard());
        }
        return true;
    }

    public static int getLongestLine(List<String> lines, Player player) {
        int longest = 0;
        for (String line : lines) {
            String string;
            if (line.contains("<scroll>") || (string = Messages.getReplacements(line, player)).length() <= longest) continue;
            longest = string.length();
        }
        return longest;
    }
}

